/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccountingEntrySetACL
extends JCRAccountingEntry
implements AccountingEntryShare {
    private final String itemName;
    private final List<String> members;
    protected static Logger logger = LoggerFactory.getLogger(JCRAccountingEntrySetACL.class);

    public JCRAccountingEntrySetACL(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.ITEM_NAME));
        this.members = (List)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.MEMBERS));
    }

    public JCRAccountingEntrySetACL(String id, String user, Calendar date, String itemName, List<String> members) {
        super(id, user, date);
        this.itemName = itemName;
        this.members = members;
        Map properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)itemName));
        String[] array = members.toArray(new String[members.size()]);
        properties.put(AccountingProperty.MEMBERS, new XStream().toXML((Object)array));
        this.entryDelegate.setEntryType(AccountingEntryType.SET_ACL);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.SET_ACL;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s]]", parentValue, this.getEntryType());
    }

    public String getItemName() {
        return this.itemName;
    }

    public List<String> getMembers() {
        return this.members;
    }
}

