/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingFolderEntryAdd
extends JCRAccountingEntry
implements AccountingEntryAdd {
    private final WorkspaceItemType itemType;
    private final FolderItemType folderItemType;
    private final String itemName;
    private final String mimeType;

    public JCRAccountingFolderEntryAdd(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.ITEM_NAME));
        this.itemType = (WorkspaceItemType)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.ITEM_TYPE));
        this.folderItemType = (FolderItemType)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.FOLDER_ITEM_TYPE));
        this.mimeType = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.MIME_TYPE));
    }

    public JCRAccountingFolderEntryAdd(String id, String user, Calendar date, WorkspaceItemType itemType, FolderItemType folderItemType, String itemName, String mimeType) {
        super(id, user, date);
        this.itemName = itemName;
        this.folderItemType = folderItemType;
        this.itemType = itemType;
        this.mimeType = mimeType;
        Map properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)itemName));
        properties.put(AccountingProperty.FOLDER_ITEM_TYPE, new XStream().toXML((Object)folderItemType));
        properties.put(AccountingProperty.ITEM_TYPE, new XStream().toXML((Object)itemType));
        properties.put(AccountingProperty.MIME_TYPE, new XStream().toXML((Object)mimeType));
        this.entryDelegate.setEntryType(AccountingEntryType.ADD);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.ADD;
    }

    public WorkspaceItemType getItemType() {
        return this.itemType;
    }

    public FolderItemType getFolderItemType() {
        return this.folderItemType;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s, itemName:%s, itemType:%s, folderItemType:%s, mimeType:%s]]", parentValue, AccountingEntryType.ADD, this.itemName, this.itemType, this.folderItemType, this.mimeType);
    }
}

