/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import ij.ImagePlus;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRImage
extends JCRFile
implements Image {
    private static final String noPreviewImg = "/no-thumbnail.png";
    private static final int THUMB_HEIGHT = 200;
    private static final int THUMB_WIDTH = 281;
    protected static Logger logger = LoggerFactory.getLogger(JCRImage.class);

    public JCRImage(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRImage(JCRWorkspace workspace, ItemDelegate delegate, InputStream is) throws RemoteBackendException, RepositoryException, IOException, InternalErrorException {
        super(workspace, delegate, is);
    }

    public JCRImage(JCRWorkspace workspace, ItemDelegate itemDelegate, MetaInfo info) throws InternalErrorException {
        super(workspace, itemDelegate, info);
    }

    public int getWidth() {
        Integer width = 0;
        try {
            width = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.IMAGE_WIDTH)));
        }
        catch (Exception e) {
            logger.error("Width not set for item " + this.itemDelegate.getPath());
        }
        return width;
    }

    public int getHeight() {
        Integer height = 0;
        try {
            height = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.IMAGE_HEIGHT)));
        }
        catch (Exception e) {
            logger.error("Height not set for item " + this.itemDelegate.getPath());
        }
        return height;
    }

    public InputStream getThumbnail() throws InternalErrorException {
        int[] thumbnailSize = null;
        InputStream thumbnailStream = null;
        ImagePlus imagePlus = null;
        try {
            String path = this.getPublicLink();
            imagePlus = WorkspaceItemUtil.getImgePlus(path);
            int width = imagePlus.getWidth();
            int height = imagePlus.getHeight();
            thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
            thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus, thumbnailSize);
            int thumbWidth = thumbnailSize[0];
            int thumbHeight = thumbnailSize[1];
            if (this.getHeight() != height && this.getWidth() != width) {
                this.setDimensions(thumbWidth, thumbHeight, width, height);
            }
        }
        catch (Exception e) {
            thumbnailStream = JCRImage.class.getResourceAsStream(noPreviewImg);
        }
        return thumbnailStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDimensions(int thumbWidth, int thumbHeight, int width, int height) {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.getPortalLogin(), false);
            Map content = this.itemDelegate.getContent();
            content.put(NodeProperty.IMAGE_WIDTH, new XStream().toXML((Object)width));
            content.put(NodeProperty.IMAGE_HEIGHT, new XStream().toXML((Object)height));
            content.put(NodeProperty.THUMBNAIL_WIDTH, new XStream().toXML((Object)thumbWidth));
            content.put(NodeProperty.THUMBNAIL_HEIGHT, new XStream().toXML((Object)thumbHeight));
            this.itemDelegate.setContent(content);
            servlets.saveItem(this.itemDelegate, false);
        }
        catch (Exception e) {
            logger.error("Impossible to set dimensions for " + this.itemDelegate.getPath());
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public int getThumbnailWidth() {
        Integer thumbWidth = 281;
        try {
            thumbWidth = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.THUMBNAIL_WIDTH)));
        }
        catch (Exception e) {
            logger.error("Thumbnail widht not set for item " + this.itemDelegate.getPath());
        }
        return thumbWidth;
    }

    public int getThumbnailHeight() {
        Integer thumbHeight = 200;
        try {
            thumbHeight = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.THUMBNAIL_HEIGHT)));
        }
        catch (Exception e) {
            logger.error("Thumbnail Height not set for item " + this.itemDelegate.getPath());
        }
        return thumbHeight;
    }

    @Override
    public void updateInfo(JCRSession servlets, MetaInfo info) throws InternalErrorException {
        logger.debug("Udpate info in image " + this.itemDelegate.getPath());
        super.updateInfo(servlets, info);
    }
}

