/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRLockManager {
    private Logger logger = LoggerFactory.getLogger(JCRLockManager.class);
    private String login;
    private String sessionId;
    private Map<String, GCoreEndpoint.Profile.Endpoint> servlets = JCRRepository.servlets;

    public JCRLockManager(String login, String sessionId) {
        this.login = login;
        this.sessionId = sessionId;
    }

    public boolean lockItem(String id) throws InternalErrorException {
        this.logger.debug("Calling Servlet Lock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        boolean locked = false;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("LockSession").uri().toString() + "?login=" + this.login + "&id=" + id + "&uuid=" + this.sessionId);
            TokenUtility.setHeader(getMethod);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            locked = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return locked;
    }

    public void unlockItem(String id) throws InternalErrorException {
        this.logger.debug("Calling Servlet UnLock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("UnlockSession").uri().toString() + "?login=" + this.login + "&id=" + id + "&uuid=" + this.sessionId);
            TokenUtility.setHeader(getMethod);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public boolean isLocked(String id) throws InternalErrorException {
        this.logger.debug("Calling Servlet isLock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        boolean isLocked = false;
        try {
            getMethod = new GetMethod(this.servlets.get("IsLocked").uri().toString() + "?login=" + this.login + "&id=" + id);
            TokenUtility.setHeader(getMethod);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            isLocked = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return isLocked;
    }
}

