package org.gcube.common.homelibary.model.items;

import java.util.Calendar;
import java.util.List;
import java.util.Map;

import lombok.Data;

import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;

@Data
public class ItemDelegate {

	String id;

	String name;

	String title;

	String description;

	String lastModifiedBy;

	String parentId;

	String parentPath;

	Calendar lastModificationTime;

	Calendar creationTime;

	Map<NodeProperty, String> properties;

	String path;

	String owner;

	String primaryType;

	WorkspaceItemAction lastAction;

	boolean shared;

	boolean locked;

	List <AccountingDelegate> accounting;

	Map<String,String> metadata;

	Map<NodeProperty, String> content;


	public ItemDelegate addItem(String name, String type) {
		ItemDelegate delegate = new ItemDelegate();
		delegate.setName(name);
		if (type!=null)
			delegate.setPrimaryType(type);
		delegate.setParentId(getId());
		return delegate;
	}

	//
	//	/**
	//	 * @return the path
	//	 */
	//	public String getPath() {
	//		return StringEscapeUtils.unescapeXml(path);
	//	}
	//
	//
	//	/**
	//	 * @param name the path to set
	//	 */
	//	public void setPath(String path) {
	//		this.path = StringEscapeUtils.escapeXml(path);
	//	}
	//	
	//	/**
	//	 * @return the name
	//	 */
	//	public String getName() {
	//		return StringEscapeUtils.unescapeXml(name);
	//	}
	//
	//
	//	/**
	//	 * @param name the name to set
	//	 */
	//	public void setName(String name) {
	//		this.name = StringEscapeUtils.escapeXml(name);
	//	}




}
