/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.testdata.TwinDataManager;
import org.gcube.common.homelibrary.testdata.data.DocMetadata;
import org.gcube.common.homelibrary.testdata.data.ImageDocumentData;
import org.gcube.common.homelibrary.testdata.data.PDFDocumentData;
import org.gcube.common.homelibrary.testdata.data.TestData;
import org.gcube.common.homelibrary.testdata.data.UrlDocumentData;

public class DocumentDataManager
extends TwinDataManager<TestData, ExternalFile, Document> {
    public DocumentDataManager() {
        super("");
    }

    @Override
    protected List<TestData> loadData(String dataListFile) {
        LinkedList<TestData> data = new LinkedList<TestData>();
        data.addAll(super.loadData("images.xml"));
        data.addAll(super.loadData("pdfs.xml"));
        data.addAll(super.loadData("urls.xml"));
        this.logger.trace("Loaded " + data.size() + " test data.");
        return data;
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("metadata", DocMetadata.class);
        this.xstream.alias("url", UrlDocumentData.class);
        this.xstream.alias("urls", LinkedList.class);
        this.xstream.alias("image", ImageDocumentData.class);
        this.xstream.alias("images", LinkedList.class);
        this.xstream.alias("pdf", PDFDocumentData.class);
        this.xstream.alias("pdfs", LinkedList.class);
    }

    @Override
    protected Document createDocument(WorkspaceFolder destinationFolder, String name, String description, String oid, String mimeType, InputStream data, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        System.out.println(" ######################## Start creation document ");
        Document document = destinationFolder.createDocumentItem(name, description, oid, mimeType, data, metadata, annotations, collectionName);
        System.out.println(" ####################### finish creation document ");
        return document;
    }

    @Override
    protected ExternalFile createExternal(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream data) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        return destinationFolder.createExternalFileItem(name, description, mimeType, data);
    }
}

