/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.home.workspace;

import java.util.Calendar;
import java.util.List;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;

public interface WorkspaceItem {
    public String getId() throws InternalErrorException;

    public String getName() throws InternalErrorException;

    public String getDescription() throws InternalErrorException;

    public void setDescription(String var1) throws InternalErrorException;

    public void rename(String var1) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException;

    public Calendar getCreationTime() throws InternalErrorException;

    public Calendar getLastModificationTime() throws InternalErrorException;

    public WorkspaceItemAction getLastAction() throws InternalErrorException;

    public User getOwner() throws InternalErrorException;

    public Capabilities getCapabilities();

    public Properties getProperties() throws InternalErrorException;

    public List<AccountingEntry> getAccounting();

    public WorkspaceItemType getType();

    public WorkspaceFolder getParent() throws InternalErrorException;

    public String getPath() throws InternalErrorException;

    public boolean isRoot() throws InternalErrorException;

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException;

    public void removeChild(WorkspaceItem var1) throws InternalErrorException, InsufficientPrivilegesException;

    public void remove() throws InternalErrorException, InsufficientPrivilegesException;

    public void move(WorkspaceFolder var1) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException;

    public WorkspaceItem cloneItem(String var1) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException;

    public boolean isShared() throws InternalErrorException;

    public boolean isMarkedAsRead() throws InternalErrorException;

    public List<AccountingEntryRead> getReaders() throws InternalErrorException;

    public void markAsRead(boolean var1) throws InternalErrorException;

    public String getIdSharedFolder() throws InternalErrorException;

    public String getRemotePath() throws InternalErrorException;
}

