/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.unittest.workspace;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.File;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.home.workspace.folder.items.PDF;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.Url;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.DocumentAlternativeLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.DocumentPartLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.junit.Assert;

public class UnitTestUtil {
    public static final String getID() {
        return UUID.randomUUID().toString();
    }

    public static final void testItemCreation(WorkspaceItem item, WorkspaceItem expectedParent, String expectedName, String expectedDescription, WorkspaceItemType expectedItemType) throws InternalErrorException {
        Assert.assertNotNull((String)"Created item null", (Object)item);
        Assert.assertEquals((String)"Created item have an unexpected name", (Object)expectedName, (Object)item.getName());
        Assert.assertEquals((String)"Created item have an unexpected description", (Object)expectedDescription, (Object)item.getDescription());
        Assert.assertEquals((String)"One child expected on the parent", (long)1L, (long)expectedParent.getChildren().size());
        UnitTestUtil.testRelationship(item, expectedParent);
        WorkspaceItemType itemType = item.getType();
        Assert.assertEquals((String)"Wrong workspace item type", (Object)expectedItemType, (Object)itemType);
    }

    public static final void testRelationship(WorkspaceItem expectedChild, WorkspaceItem expectedParent) throws InternalErrorException {
        boolean found = false;
        for (WorkspaceItem child : expectedParent.getChildren()) {
            if (!child.getId().equals(expectedChild.getId())) continue;
            found = true;
        }
        Assert.assertTrue((String)"The expected children has not found in the expected parent.", (boolean)found);
        String parentId = expectedChild.getParent().getId();
        String expectedParentId = expectedParent.getId();
        Assert.assertEquals((String)"The expected child parent is wrong", (Object)expectedParentId, (Object)parentId);
    }

    public static final void testTreeRelationship(WorkspaceItem expectedChild, WorkspaceItem expectedParent) throws InternalErrorException {
        UnitTestUtil.testRelationship(expectedChild, expectedParent);
        for (WorkspaceItem child : expectedChild.getChildren()) {
            UnitTestUtil.testTreeRelationship(child, expectedChild);
        }
    }

    public static final void testWorkspaceItemEquality(WorkspaceItem itemA, WorkspaceItem itemB) throws InternalErrorException {
        Assert.assertEquals((String)"Different id", (Object)itemA.getId(), (Object)itemB.getId());
        Assert.assertEquals((String)"Different name", (Object)itemA.getName(), (Object)itemB.getName());
        Assert.assertEquals((String)"Different description", (Object)itemA.getDescription(), (Object)itemB.getDescription());
        Assert.assertEquals((String)"Different creation time", (Object)itemA.getCreationTime(), (Object)itemB.getCreationTime());
        Assert.assertEquals((String)"Different last modification time", (Object)itemA.getLastModificationTime(), (Object)itemB.getLastModificationTime());
        Assert.assertEquals((String)"Different last action", (Object)itemA.getLastAction(), (Object)itemB.getLastAction());
        Assert.assertEquals((String)"Different owner", (Object)itemA.getOwner().getPortalLogin(), (Object)itemB.getOwner().getPortalLogin());
        Assert.assertEquals((String)"Different type", (Object)itemA.getType(), (Object)itemB.getType());
        Assert.assertEquals((String)"Different parent", (Object)itemA.getParent().getId(), (Object)itemB.getParent().getId());
        UnitTestUtil.testChildren(itemA, itemB);
    }

    public static final void testChildren(WorkspaceItem itemA, WorkspaceItem itemB) throws InternalErrorException {
        List itemAChildren = itemA.getChildren();
        List itemBChildren = itemB.getChildren();
        Assert.assertEquals((String)"Children cardinality different", (long)itemAChildren.size(), (long)itemBChildren.size());
        LinkedHashMap<String, WorkspaceItem> itemAChildrenMap = new LinkedHashMap<String, WorkspaceItem>();
        for (WorkspaceItem child : itemAChildren) {
            itemAChildrenMap.put(child.getId(), child);
        }
        LinkedHashMap<String, WorkspaceItem> itemBChildrenMap = new LinkedHashMap<String, WorkspaceItem>();
        for (WorkspaceItem workspaceItem : itemBChildren) {
            itemBChildrenMap.put(workspaceItem.getId(), workspaceItem);
        }
        for (Map.Entry entry : itemAChildrenMap.entrySet()) {
            if (!itemBChildrenMap.containsKey(entry.getKey())) {
                Assert.fail((String)("Child id on A " + (String)entry.getKey() + " not containted in B"));
            }
            WorkspaceItem childA = (WorkspaceItem)entry.getValue();
            WorkspaceItem childB = (WorkspaceItem)itemBChildrenMap.get(childA.getId());
            UnitTestUtil.testWorkspaceItemEquality(childA, childB);
        }
        for (String string : itemBChildrenMap.keySet()) {
            if (itemAChildrenMap.keySet().contains(string)) continue;
            Assert.fail((String)("Child id on B " + string + " not containted in A"));
        }
    }

    public static final void testCopy(WorkspaceItem item, WorkspaceItem clone, boolean differentDestination) throws InternalErrorException {
        Assert.assertNotSame((String)"Same id", (Object)item.getId(), (Object)clone.getId());
        if (differentDestination) {
            Assert.assertEquals((String)"Different name", (Object)item.getName(), (Object)clone.getName());
        } else {
            Assert.assertNotSame((String)"Same name", (Object)item.getName(), (Object)clone.getName());
        }
        Assert.assertEquals((String)"Different description", (Object)item.getDescription(), (Object)clone.getDescription());
        if (item.getOwner() != null && clone.getOwner() != null) {
            Assert.assertEquals((String)"Different owner", (Object)item.getOwner().getPortalLogin(), (Object)clone.getOwner().getPortalLogin());
        }
        Assert.assertEquals((String)"Different type", (Object)item.getType(), (Object)clone.getType());
        if (differentDestination) {
            Assert.assertNotSame((String)"Parent equals", (Object)item.getParent(), (Object)clone.getParent());
        } else {
            Assert.assertEquals((String)"Different parents", (Object)item.getParent().getId(), (Object)clone.getParent().getId());
        }
        List itemChildren = item.getChildren();
        List cloneChildren = clone.getChildren();
        System.err.println("ItemChildren " + itemChildren + "of itemType" + item.getType());
        System.err.println("CloneChildren " + cloneChildren + "of cloneType" + clone.getType());
        Assert.assertEquals((String)"Different number of children", (long)itemChildren.size(), (long)cloneChildren.size());
        for (WorkspaceItem itemChild : itemChildren) {
            WorkspaceItem cloneChild = null;
            for (WorkspaceItem candidateChild : cloneChildren) {
                if (!candidateChild.getName().equals(itemChild.getName())) continue;
                cloneChild = candidateChild;
                break;
            }
            Assert.assertNotNull((String)("Corresponding child not found for " + itemChild), cloneChild);
            UnitTestUtil.internalTestCopy(itemChild, cloneChild);
        }
    }

    protected static final void internalTestCopy(WorkspaceItem item, WorkspaceItem clone) throws InternalErrorException {
        Assert.assertNotSame((String)"Same id", (Object)item.getId(), (Object)clone.getId());
        Assert.assertEquals((String)"Different name", (Object)item.getName(), (Object)clone.getName());
        Assert.assertEquals((String)"Different description", (Object)item.getDescription(), (Object)clone.getDescription());
        if (item.getOwner() == null || item.getOwner() != null) {
            // empty if block
        }
        Assert.assertEquals((String)"Different owner", (Object)item.getOwner().getPortalLogin(), (Object)clone.getOwner().getPortalLogin());
        Assert.assertEquals((String)"Different type", (Object)item.getType(), (Object)clone.getType());
        Assert.assertNotSame((String)"Parent equals", (Object)item.getParent(), (Object)clone.getParent());
        switch (item.getType()) {
            case FOLDER_ITEM: {
                UnitTestUtil.internalTestCopyFolderItem((FolderItem)item, (FolderItem)clone);
                break;
            }
        }
        List itemChildren = item.getChildren();
        List cloneChildren = clone.getChildren();
        Assert.assertEquals((String)"Different number of children", (long)itemChildren.size(), (long)cloneChildren.size());
        for (WorkspaceItem itemChild : itemChildren) {
            WorkspaceItem cloneChild = null;
            for (WorkspaceItem candidateChild : cloneChildren) {
                if (!candidateChild.getName().equals(itemChild.getName())) continue;
                cloneChild = candidateChild;
                break;
            }
            Assert.assertNotNull((String)("Corresponding child not found for " + itemChild), cloneChild);
            UnitTestUtil.internalTestCopy(itemChild, cloneChild);
        }
    }

    protected static final void internalTestCopyFolderItem(FolderItem item, FolderItem clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different folder item type", (Object)item.getFolderItemType(), (Object)clone.getFolderItemType());
        Assert.assertEquals((String)"Different length", (long)item.getLength(), (long)clone.getLength());
        Assert.assertEquals((String)"Different Workflow Id", (Object)item.getWorkflowId(), (Object)clone.getWorkflowId());
        Assert.assertEquals((String)"Different Workflow Status", (Object)item.getWorkflowStatus(), (Object)clone.getWorkflowStatus());
        Assert.assertEquals((String)"Different Workflow Data", (Object)item.getWorkflowData(), (Object)clone.getWorkflowData());
        switch (item.getFolderItemType()) {
            case EXTERNAL_FILE: {
                UnitTestUtil.internalTestCopyFile((File)((ExternalFile)item), (File)((ExternalFile)clone));
                break;
            }
            case EXTERNAL_IMAGE: {
                UnitTestUtil.internalTestCopyImage((Image)((ExternalImage)item), (Image)((ExternalImage)clone));
                break;
            }
            case EXTERNAL_PDF_FILE: {
                UnitTestUtil.internalTestCopyFile((File)((ExternalPDFFile)item), (File)((ExternalPDFFile)clone));
                UnitTestUtil.internalTestCopyPDF((PDF)((ExternalPDFFile)item), (PDF)((ExternalPDFFile)clone));
                break;
            }
            case EXTERNAL_URL: {
                UnitTestUtil.internalTestCopyUrl((Url)((ExternalUrl)item), (Url)((ExternalUrl)clone));
                break;
            }
            case TIME_SERIES: {
                UnitTestUtil.internalTestCopyTimeSeries((TimeSeries)item, (TimeSeries)clone);
                break;
            }
            case QUERY: {
                UnitTestUtil.internalTestCopyQuery((Query)item, (Query)clone);
                break;
            }
            case REPORT: {
                UnitTestUtil.internalTestCopyReport((Report)item, (Report)clone);
                break;
            }
            case REPORT_TEMPLATE: {
                UnitTestUtil.internalTestCopyReportTemplate((ReportTemplate)item, (ReportTemplate)clone);
                break;
            }
            case AQUAMAPS_ITEM: {
                UnitTestUtil.internalTestCopyAquaMapsItem((AquaMapsItem)item, (AquaMapsItem)clone);
                break;
            }
            case DOCUMENT: {
                UnitTestUtil.internalTestCopyDocument((Document)item, (Document)clone);
                break;
            }
            case IMAGE_DOCUMENT: {
                UnitTestUtil.internalTestCopyDocument((Document)((ImageDocument)item), (Document)((ImageDocument)clone));
                UnitTestUtil.internalTestCopyImage((Image)((ImageDocument)item), (Image)((ImageDocument)clone));
                break;
            }
            case PDF_DOCUMENT: {
                UnitTestUtil.internalTestCopyDocument((Document)((PDFDocument)item), (Document)((PDFDocument)clone));
                UnitTestUtil.internalTestCopyPDF((PDF)((PDFDocument)item), (PDF)((PDFDocument)clone));
                break;
            }
            case URL_DOCUMENT: {
                UnitTestUtil.internalTestCopyDocument((Document)((UrlDocument)item), (Document)((UrlDocument)clone));
                UnitTestUtil.internalTestCopyUrl((Url)((UrlDocument)item), (Url)((UrlDocument)clone));
                break;
            }
            case METADATA: {
                UnitTestUtil.internalTestCopyMetadata((Metadata)item, (Metadata)clone);
                break;
            }
        }
    }

    protected static final void internalTestCopyFile(File item, File clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different name", (Object)item.getName(), (Object)clone.getName());
        Assert.assertEquals((String)"Different mimetype", (Object)item.getMimeType(), (Object)clone.getMimeType());
        Assert.assertEquals((String)"Different length", (long)item.getLength(), (long)clone.getLength());
        try {
            boolean sameContent = IOUtils.contentEquals((InputStream)item.getData(), (InputStream)clone.getData());
            Assert.assertTrue((String)"The data are differents", (boolean)sameContent);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static final void internalTestCopyImage(Image item, Image clone) throws InternalErrorException {
        UnitTestUtil.internalTestCopyFile((File)item, (File)clone);
        Assert.assertEquals((String)"Different widths", (long)item.getWidth(), (long)clone.getWidth());
        Assert.assertEquals((String)"Different heights", (long)item.getHeight(), (long)clone.getHeight());
        Assert.assertEquals((String)"Different thumbnail widths", (long)item.getThumbnailWidth(), (long)clone.getThumbnailHeight());
        Assert.assertEquals((String)"Different thumbnail height", (long)item.getThumbnailHeight(), (long)clone.getThumbnailHeight());
        Assert.assertEquals((String)"Different thumbnail length", (long)item.getThumbnailLength(), (long)clone.getThumbnailLength());
        try {
            boolean sameContent = IOUtils.contentEquals((InputStream)item.getThumbnail(), (InputStream)clone.getThumbnail());
            Assert.assertTrue((String)"The thumbnail content are differents", (boolean)sameContent);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static final void internalTestCopyPDF(PDF item, PDF clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different titles", (Object)item.getTitle(), (Object)clone.getTitle());
        Assert.assertEquals((String)"Different authors", (Object)item.getAuthor(), (Object)clone.getAuthor());
        Assert.assertEquals((String)"Different producers", (Object)item.getProducer(), (Object)clone.getProducer());
        Assert.assertEquals((String)"Different versions", (Object)item.getVersion(), (Object)clone.getVersion());
        Assert.assertEquals((String)"Different number of pages", (long)item.getNumberOfPages(), (long)clone.getNumberOfPages());
    }

    protected static final void internalTestCopyUrl(Url item, Url clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different url values", (Object)item.getUrl(), (Object)clone.getUrl());
    }

    /*
     * WARNING - void declaration
     */
    protected static final void internalTestCopyDocument(Document item, Document clone) throws InternalErrorException {
        void var2_8;
        void var2_5;
        Assert.assertEquals((String)"Different oid values", (Object)item.getURI(), (Object)clone.getURI());
        Assert.assertEquals((String)"Different mimetype", (Object)item.getMimeType(), (Object)clone.getMimeType());
        Assert.assertEquals((String)"Different collection name", (Object)item.getCollectionName(), (Object)clone.getCollectionName());
        System.err.println("ITEM METADATA :" + item.getMetadata());
        System.err.println("CLONE METADA " + clone.getMetadata());
        Assert.assertEquals((String)"Different Metadata cardinality", (long)item.getMetadata().size(), (long)clone.getMetadata().size());
        Assert.assertTrue((String)"Different metadata (keys)", (boolean)item.getMetadata().keySet().containsAll(clone.getMetadata().keySet()));
        for (Map.Entry entry : item.getMetadata().entrySet()) {
            DocumentMetadata cloneMetadata = (DocumentMetadata)clone.getMetadata().get(entry.getKey());
            Assert.assertEquals((String)"(Metadata) Different schema name", (Object)((DocumentMetadata)entry.getValue()).getSchemaName(), (Object)cloneMetadata.getSchemaName());
            Assert.assertEquals((String)"(Metadata) Different xmls", (Object)((DocumentMetadata)entry.getValue()).getXML(), (Object)cloneMetadata.getXML());
        }
        Assert.assertEquals((String)"Different Alternatives cardinality", (long)item.getAlternatives().size(), (long)clone.getAlternatives().size());
        boolean bl = false;
        while (var2_5 < item.getAlternatives().size()) {
            DocumentAlternativeLink itemAlternative = (DocumentAlternativeLink)item.getAlternatives().get((int)var2_5);
            DocumentAlternativeLink cloneAlternative = (DocumentAlternativeLink)clone.getAlternatives().get((int)var2_5);
            Assert.assertEquals((String)"(Alternative) Different parent oid", (Object)itemAlternative.getParentURI(), (Object)cloneAlternative.getParentURI());
            Assert.assertEquals((String)"(Alternative) Different oid", (Object)itemAlternative.getURI(), (Object)cloneAlternative.getURI());
            Assert.assertEquals((String)"(Alternative) Different name", (Object)itemAlternative.getName(), (Object)cloneAlternative.getName());
            Assert.assertEquals((String)"(Alternative) Different mime type", (Object)itemAlternative.getMimeType(), (Object)cloneAlternative.getMimeType());
            ++var2_5;
        }
        Assert.assertEquals((String)"Different Annotation cardinality", (long)item.getAnnotation().size(), (long)clone.getAnnotation().size());
        Assert.assertTrue((String)"Different Annotation (keys)", (boolean)item.getAnnotation().keySet().containsAll(clone.getAnnotation().keySet()));
        for (Map.Entry entry : item.getAnnotation().entrySet()) {
            String cloneAnnotation = (String)clone.getAnnotation().get(entry.getKey());
            Assert.assertEquals((String)"(Annotation) Different annotation", entry.getValue(), (Object)cloneAnnotation);
        }
        Assert.assertEquals((String)"Different Parts cardinality", (long)item.getParts().size(), (long)clone.getParts().size());
        boolean bl2 = false;
        while (var2_8 < item.getParts().size()) {
            DocumentPartLink itemPart = (DocumentPartLink)item.getParts().get((int)var2_8);
            DocumentPartLink clonePart = (DocumentPartLink)clone.getParts().get((int)var2_8);
            Assert.assertEquals((String)"(Part) Different parent oid", (Object)itemPart.getParentURI(), (Object)clonePart.getParentURI());
            Assert.assertEquals((String)"(Part) Different oid", (Object)itemPart.getURI(), (Object)clonePart.getURI());
            Assert.assertEquals((String)"(Part) Different name", (Object)itemPart.getName(), (Object)clonePart.getName());
            Assert.assertEquals((String)"(Part) Different mime type", (Object)itemPart.getMimeType(), (Object)clonePart.getMimeType());
            ++var2_8;
        }
        try {
            boolean bl3 = IOUtils.contentEquals((InputStream)item.getData(), (InputStream)clone.getData());
            Assert.assertTrue((String)"The data are differents", (boolean)bl3);
        }
        catch (IOException iOException) {
            throw new InternalErrorException((Throwable)iOException);
        }
    }

    protected static final void internalTestCopyMetadata(Metadata item, Metadata clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different oid values", (Object)item.getURI(), (Object)clone.getURI());
        Assert.assertEquals((String)"Different schema", (Object)item.getSchema(), (Object)clone.getSchema());
        Assert.assertEquals((String)"Different language", (Object)item.getLanguage(), (Object)clone.getLanguage());
        Assert.assertEquals((String)"Different collection name", (Object)item.getCollectionName(), (Object)clone.getCollectionName());
        Assert.assertEquals((String)"Different data", (Object)item.getData(), (Object)clone.getData());
    }

    protected static final void internalTestCopyTimeSeries(TimeSeries item, TimeSeries clone) throws InternalErrorException {
        boolean sameContent;
        Assert.assertEquals((String)"Different TimeSeries info", (Object)item.getTimeSeriesInfo(), (Object)clone.getTimeSeriesInfo());
        Assert.assertEquals((String)"Different number of columns", (long)item.getNumberOfColumns(), (long)clone.getNumberOfColumns());
        Assert.assertEquals((String)"Different header labels", (Object)item.getHeaderLabels(), (Object)clone.getHeaderLabels());
        try {
            sameContent = IOUtils.contentEquals((InputStream)item.getData(), (InputStream)clone.getData());
            Assert.assertTrue((String)"The data are differents", (boolean)sameContent);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        try {
            sameContent = IOUtils.contentEquals((InputStream)item.getCompressedData(), (InputStream)clone.getCompressedData());
            Assert.assertTrue((String)"The compressed data are differents", (boolean)sameContent);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static final void internalTestCopyQuery(Query item, Query clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different type", (Object)item.getQueryType(), (Object)clone.getQueryType());
        Assert.assertEquals((String)"Different query value", (Object)item.getQuery(), (Object)clone.getQuery());
    }

    protected static final void internalTestCopyReport(Report item, Report clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different created", (Object)item.getCreated(), (Object)clone.getCreated());
        Assert.assertEquals((String)"Different lastEdit", (Object)item.getLastEdit(), (Object)clone.getLastEdit());
        Assert.assertEquals((String)"Different author", (Object)item.getAuthor(), (Object)clone.getAuthor());
        Assert.assertEquals((String)"Different lastEditBy", (Object)item.getLastEditBy(), (Object)clone.getLastEditBy());
        Assert.assertEquals((String)"Different templateName", (Object)item.getTemplateName(), (Object)clone.getTemplateName());
        Assert.assertEquals((String)"Different numberOfSections", (long)item.getNumberOfSections(), (long)clone.getNumberOfSections());
        Assert.assertEquals((String)"Different status", (Object)item.getStatus(), (Object)clone.getStatus());
        try {
            boolean sameContent = IOUtils.contentEquals((InputStream)item.getData(), (InputStream)clone.getData());
            Assert.assertTrue((String)"The data are differents", (boolean)sameContent);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static final void internalTestCopyReportTemplate(ReportTemplate item, ReportTemplate clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different created", (Object)item.getCreated(), (Object)clone.getCreated());
        Assert.assertEquals((String)"Different lastEdit", (Object)item.getLastEdit(), (Object)clone.getLastEdit());
        Assert.assertEquals((String)"Different author", (Object)item.getAuthor(), (Object)clone.getAuthor());
        Assert.assertEquals((String)"Different lastEditBy", (Object)item.getLastEditBy(), (Object)clone.getLastEditBy());
        Assert.assertEquals((String)"Different numberOfSections", (long)item.getNumberOfSections(), (long)clone.getNumberOfSections());
        Assert.assertEquals((String)"Different status", (Object)item.getStatus(), (Object)clone.getStatus());
        try {
            boolean sameContent = IOUtils.contentEquals((InputStream)item.getData(), (InputStream)clone.getData());
            Assert.assertTrue((String)"The data are differents", (boolean)sameContent);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static final void internalTestCopyAquaMapsItem(AquaMapsItem item, AquaMapsItem clone) throws InternalErrorException {
        Assert.assertEquals((String)"Different MapName", (Object)item.getMapName(), (Object)clone.getMapName());
        Assert.assertEquals((String)"Different MapType", (Object)item.getMapType(), (Object)clone.getMapType());
        Assert.assertEquals((String)"Different Author", (Object)item.getAuthor(), (Object)clone.getAuthor());
        Assert.assertEquals((String)"Different NumberOfSpecies", (long)item.getNumberOfSpecies(), (long)clone.getNumberOfSpecies());
        Assert.assertEquals((String)"Different BoundingBox", (Object)item.getBoundingBox(), (Object)clone.getBoundingBox());
        Assert.assertEquals((String)"Different PsoThreshold", (double)item.getPsoThreshold(), (double)clone.getPsoThreshold(), (double)0.0);
        Assert.assertEquals((String)"Different NumberOfGeneratedImages", (long)item.getNumberOfGeneratedImages(), (long)clone.getNumberOfGeneratedImages());
        UnitTestUtil.internalTestCopyFile(item.getMetadata(), clone.getMetadata());
        Assert.assertEquals((String)"Different number of images", (long)item.getImages().size(), (long)clone.getImages().size());
    }

    public static final WorkspaceFolder getFolderTree(WorkspaceFolder root, String folderName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        WorkspaceFolder folder = root.createFolder(folderName, "A test Folder");
        TestDataFactory testDataManager = TestDataFactory.getInstance();
        testDataManager.fillExternalImages(folder, 1);
        testDataManager.fillExternalFiles(folder, 1);
        testDataManager.fillExternalPDFFiles(folder, 1);
        testDataManager.fillExternalUrls(folder, 1);
        testDataManager.fillQueries(folder, 1);
        testDataManager.fillReportTemplates(folder, 1);
        testDataManager.fillReports(folder, 1);
        testDataManager.fillTimeSeries(folder, 1);
        testDataManager.fillAquaMapsItems(folder, 1);
        testDataManager.fillDocuments(folder, 1);
        testDataManager.fillImageDocuments(folder, 1);
        testDataManager.fillPDFDocuments(folder, 1);
        testDataManager.fillUrlDocuments(folder, 1);
        testDataManager.fillMetadata(folder, 1);
        testDataManager.fillWorkflowReports(folder, 1);
        testDataManager.fillWorkflowTemplates(folder, 1);
        return folder;
    }

    public static final void testDocumentCreation(Document item, WorkspaceItem expectedParent, String expectedName, String expectedDescription, String expectedMimeType, WorkspaceItemType expectedItemType, String expectedOid, String expectedCollectionName, Map<String, String> expectedMetadata, Map<String, String> expectedAnnotation) throws InternalErrorException {
        UnitTestUtil.testItemCreation((WorkspaceItem)item, expectedParent, expectedName, expectedDescription, expectedItemType);
        Assert.assertEquals((String)"Different oid", (Object)expectedOid, (Object)item.getURI());
        Assert.assertEquals((String)"Different collection name", (Object)expectedCollectionName, (Object)item.getCollectionName());
        Assert.assertEquals((String)"Different mime type", (Object)expectedMimeType, (Object)item.getMimeType());
    }

    public static final <K, V> void checkMapEquality(Map<K, V> a, Map<K, V> b) {
        Assert.assertEquals((String)"Different cardinality", (long)a.size(), (long)b.size());
        Assert.assertEquals((String)"Different keyset cardinality", (long)a.keySet().size(), (long)b.keySet().size());
        for (K k : a.keySet()) {
            if (b.containsKey(k)) continue;
            Assert.fail((String)("Key " + k + " in A is not in B"));
        }
        for (K k : b.keySet()) {
            if (a.containsKey(k)) continue;
            Assert.fail((String)("Key " + k + " in B is not in A"));
        }
        Assert.assertEquals((String)"Different valueset cardinality", (long)a.values().size(), (long)b.values().size());
        for (Map.Entry entry : a.entrySet()) {
            Object key = entry.getKey();
            if (!b.containsKey(key)) {
                Assert.fail((String)("Key " + key + " in A is not in B"));
            }
            V bValue = b.get(key);
            Object value = entry.getValue();
            Assert.assertEquals((String)("Different values for key " + key), value, bValue);
        }
    }

    public static final void testMoveItem(WorkspaceItem item, WorkspaceFolder destination, Workspace workspace) throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder parent = item.getParent();
        workspace.moveItem(item.getId(), destination.getId());
        Assert.assertNotNull((String)"The moved item parent is null", (Object)item.getParent());
        Assert.assertEquals((String)"Children founds on old parent", (long)0L, (long)parent.getChildren().size());
        try {
            workspace.getItem(item.getId());
        }
        catch (ItemNotFoundException e) {
            Assert.fail((String)"Item not found after move.");
        }
        UnitTestUtil.testRelationship(item, (WorkspaceItem)destination);
    }

    public static final void checkSubTreeExistence(Workspace wa, WorkspaceItem root) throws InternalErrorException {
        Assert.assertFalse((String)("Found item " + root), (boolean)wa.exists(root.getId()));
        for (WorkspaceItem child : root.getChildren()) {
            UnitTestUtil.checkSubTreeExistence(wa, child);
        }
    }
}

