/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.home;

import java.io.File;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.data.ApplicationsArea;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.util.config.HomeLibraryConfiguration;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeLibrary {
    public static final String HOME_ATTRIBUTE_NAME = "USER_HOME";
    protected static Logger staticLogger = LoggerFactory.getLogger((String)"HomeManageFactory");
    protected static HomeManagerFactory instance;

    protected static HomeManagerFactory getHomeManagerFactoryImplementation() throws InternalErrorException {
        try {
            Class<?> homeManagerFactoryClass = HomeLibraryConfiguration.getInstance().getHomeManagerFactoryClass();
            return (HomeManagerFactory)homeManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            staticLogger.error("An error occured retrieving the HomeManagerFactory implementation.", (Throwable)e);
            throw new InternalErrorException("An error occured retrieving the HomeManagerFactory implementation.", e);
        }
    }

    protected static void checkPersistenceFolder(String persistenceFolder) throws InternalErrorException {
        staticLogger.trace("persistenceFolder = " + persistenceFolder);
        File persistenceDir = new File(persistenceFolder);
        if (!persistenceDir.exists()) {
            staticLogger.trace("The persistence folder don't exists, creating it");
            boolean created = persistenceDir.mkdirs();
            if (!created) {
                staticLogger.error("FATAL: the home library can't create his persistence folder!!! " + persistenceFolder);
                System.err.println("FATAL: the home library can't create his persistence folder!!! " + persistenceFolder);
                throw new InternalErrorException("FATAL: the home library can't create his persistence folder!!! " + persistenceFolder);
            }
        } else {
            staticLogger.trace("The persistence folder exists");
        }
    }

    protected static synchronized HomeManagerFactory createHomeManagerFactoryInstance(String persistenceRoot) throws InternalErrorException {
        HomeLibrary.checkPersistenceFolder(persistenceRoot);
        HomeManagerFactory homeManagerFactory = HomeLibrary.getHomeManagerFactoryImplementation();
        homeManagerFactory.initialize(persistenceRoot);
        return homeManagerFactory;
    }

    public static synchronized HomeManagerFactory getHomeManagerFactory(String persistenceRoot) throws InternalErrorException {
        staticLogger.info("getInstance persistenceRoot: " + persistenceRoot);
        if (instance == null) {
            instance = HomeLibrary.createHomeManagerFactoryInstance(persistenceRoot);
        }
        return instance;
    }

    public static HomeManagerFactory getHomeManagerFactory() throws InternalErrorException {
        staticLogger.info("getHomeManagerFactory");
        if (instance != null) {
            return instance;
        }
        String persistenceRoot = HomeLibraryConfiguration.getInstance().getPersistenceFolder();
        return HomeLibrary.getHomeManagerFactory(persistenceRoot);
    }

    public static Workspace getUserWorkspace(String portalLogin) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        if (portalLogin == null) {
            staticLogger.error("user parameter null");
            throw new IllegalArgumentException("user can't be null.");
        }
        Home home = HomeLibrary.getUserHome(portalLogin);
        return home.getWorkspace();
    }

    public static ApplicationsArea getUserDataArea(String portalLogin) throws InternalErrorException, HomeNotFoundException {
        if (portalLogin == null) {
            staticLogger.error("user parameter null");
            throw new IllegalArgumentException("user can't be null.");
        }
        Home home = HomeLibrary.getUserHome(portalLogin);
        return home.getDataArea();
    }

    public static Home getUserHome(String portalLogin) throws InternalErrorException, HomeNotFoundException {
        String username = portalLogin;
        String scope = ScopeProvider.instance.get();
        if (username == null) {
            staticLogger.error("The username is null");
            throw new IllegalArgumentException("The username  is null.");
        }
        if (scope == null) {
            staticLogger.error("The scope in session is null");
            throw new IllegalArgumentException("The scope is null.");
        }
        staticLogger.info("loading home. (Username: " + username + ", scope: " + scope + ")");
        HomeManagerFactory homeManagerFactory = HomeLibrary.getHomeManagerFactory();
        HomeManager homeManager = homeManagerFactory.getHomeManager();
        System.out.println("************* " + username);
        User user = homeManager.getUser(username);
        Home home = homeManager.getHome(user);
        return home;
    }
}

