/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.performance.tool;

import java.util.LinkedList;
import java.util.List;
import org.gcube.common.homelibrary.performance.tool.MeasurementData;
import org.gcube.common.homelibrary.performance.tool.MeasurementSession;

public class MeasurementChannel {
    protected String name;
    protected List<MeasurementData> data;
    protected long startTime = 0L;
    protected MeasurementSession session;

    protected MeasurementChannel(String name, MeasurementSession session) {
        this.name = name;
        this.session = session;
        this.data = new LinkedList<MeasurementData>();
    }

    public String getName() {
        return this.name;
    }

    public List<MeasurementData> getData() {
        return this.data;
    }

    public void startMeasure() {
        this.startTime = System.nanoTime();
    }

    public void stopMeasure() {
        long stopTime = System.nanoTime();
        long time = stopTime - this.startTime;
        MeasurementData data = new MeasurementData(time, this.session.getCurrentValue());
        this.addData(data);
        this.startTime = 0L;
        this.session.addData(this.name, data);
    }

    public void addData(MeasurementData data) {
        this.data.add(data);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Channel [data=");
        builder.append(this.data);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }
}

