/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.util.List;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.util.IndentedVisitor;
import org.gcube.common.homelibrary.util.WorkspaceTreeVisitor;

public class HomeLibraryVisitor
extends IndentedVisitor {
    protected boolean visitHomes = false;

    public HomeLibraryVisitor() {
    }

    public HomeLibraryVisitor(boolean visitHomes) {
        this.visitHomes = visitHomes;
    }

    public void visitHomeLibrary(HomeManagerFactory factory) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        this.reset();
        List<String> scopes = factory.listScopes();
        for (String scope : scopes) {
            this.println(scope);
            HomeManager homeManager = factory.getHomeManager();
            this.visitHomeManager(homeManager);
        }
    }

    protected void visitHomeManager(HomeManager homeManager) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        this.indent();
        List<User> users = homeManager.getUsers();
        for (User user : users) {
            this.println(user.getPortalLogin());
            if (!this.visitHomes) continue;
            Home home = homeManager.getHome(user);
            this.visitUser(home);
        }
        this.outdent();
    }

    protected void visitUser(Home home) throws InternalErrorException, WorkspaceFolderNotFoundException {
        this.indent();
        WorkspaceTreeVisitor wtv = new WorkspaceTreeVisitor(this.indentationLevel, this.indentationChar, this.os);
        wtv.visitItem(home.getWorkspace().getRoot());
        this.outdent();
    }
}

