/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.testdata.AbstractDataManager;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.testdata.data.AquaMapItemData;
import org.gcube.common.homelibrary.util.WorkspaceUtil;

public class AquaMapItemDataManager
extends AbstractDataManager<AquaMapItemData, WorkspaceFolder> {
    public AquaMapItemDataManager() {
        super("aquamapitems.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("aquamapitem", AquaMapItemData.class);
        this.xstream.alias("aquamapitems", LinkedList.class);
        this.xstream.alias("images", LinkedHashMap.class);
    }

    protected static InputStream getTestDataStream(String file) {
        String testDataPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + file;
        return TestDataFactory.class.getResourceAsStream(testDataPath);
    }

    @Override
    protected WorkspaceFolder fillData(WorkspaceFolder destinationFolder, AquaMapItemData testData) throws InternalErrorException {
        try {
            InputStream metadata = AquaMapItemDataManager.getTestDataStream(testData.getMetadataFile());
            LinkedHashMap<String, InputStream> images = new LinkedHashMap<String, InputStream>();
            for (Map.Entry<String, String> image : testData.getImageFiles().entrySet()) {
                images.put(image.getKey(), AquaMapItemDataManager.getTestDataStream(image.getValue()));
            }
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return destinationFolder.createAquaMapsItem(name, testData.getDescription(), testData.getMapName(), testData.getMapType(), testData.getAuthor(), testData.getNumberOfSpecies(), testData.getBoundingBox(), testData.getPsoThreshold(), testData.getNumberOfGeneratedImages(), metadata, images);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error("Error creating the aquamaps item", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error("Error creating the aquamaps item", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            this.logger.error("Error creating the aquamaps item", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            this.logger.error("Error creating the aquamaps item", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

