/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.testdata;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.testdata.data.DocMetadata;
import org.gcube.common.homelibrary.testdata.data.TestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataManagerUtil {
    protected static final Logger logger = LoggerFactory.getLogger(TestDataManagerUtil.class);

    public static String loadFileAsString(InputStream file) throws InternalErrorException {
        try {
            StringBuilder sb = new StringBuilder();
            int reads = 0;
            byte[] buffer = new byte[1024];
            while ((reads = file.read(buffer)) >= 0) {
                sb.append(new String(buffer, 0, reads));
            }
            file.close();
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("Error loading file from InputStream", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static String loadMetadata(DocMetadata docMetadata) throws InternalErrorException {
        InputStream metadataFile = TestDataFactory.class.getResourceAsStream("/org/gcube/portlets/user/homelibrary/testdata/resources/" + docMetadata.getFile());
        return TestDataManagerUtil.loadFileAsString(metadataFile);
    }

    protected static Map<String, String> loadMetadatas(List<DocMetadata> docMetadatas) throws InternalErrorException {
        LinkedHashMap<String, String> metadatas = new LinkedHashMap<String, String>();
        for (DocMetadata docMetadata : docMetadatas) {
            String data = TestDataManagerUtil.loadMetadata(docMetadata);
            metadatas.put(docMetadata.getName(), data);
        }
        return metadatas;
    }

    protected static InputStream getTestDataStream(TestData testData) {
        logger.trace("getTestDataStream testData: " + testData);
        String testDataPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + testData.getFile();
        logger.trace("TestDataStream path: " + testDataPath);
        return TestDataFactory.class.getResourceAsStream(testDataPath);
    }

    public static String getUID() {
        return UUID.randomUUID().toString();
    }
}

