/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.MimeTypeUtil;

public class WorkspaceUtil {
    private static final String READ_ONLY = "jcr:read";
    private static final String WRITE_OWNER = "jcr:write";
    private static final String WRITE_ALL = "hl:writeAll";
    private static final String ADMINISTRATOR = "jcr:all";

    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = null;
        try {
            name = folder.getUniqueName(initialName, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = initialName;
        }
        return name;
    }

    public static String getCopyName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = null;
        try {
            name = folder.getUniqueName(initialName, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = initialName;
        }
        return name;
    }

    public static String returnThreeDigitNo(int number) {
        String threeDigitNo = null;
        int length = String.valueOf(number).length();
        if (length == 1) {
            threeDigitNo = "00" + number;
        }
        if (length == 2) {
            threeDigitNo = "0" + number;
        }
        if (length == 3) {
            threeDigitNo = "" + number;
        }
        return threeDigitNo;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        File tmpFile = null;
        try {
            String mimeTypeChecked;
            block15: {
                tmpFile = WorkspaceUtil.getTmpFile(is);
                if (mimeType == null) {
                    FileInputStream tmpIs = null;
                    try {
                        try {
                            tmpIs = new FileInputStream(tmpFile);
                            mimeType = MimeTypeUtil.getMimeType(name, tmpIs);
                            is = new FileInputStream(tmpFile);
                        }
                        catch (Exception exception) {
                            if (tmpIs != null) {
                                tmpIs.close();
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (tmpIs != null) {
                            tmpIs.close();
                        }
                        throw throwable;
                    }
                    if (tmpIs != null) {
                        tmpIs.close();
                    }
                }
            }
            if ((mimeTypeChecked = mimeType) != null) {
                if (mimeTypeChecked.startsWith("image")) {
                    return destinationFolder.createExternalImageItem(name, description, mimeTypeChecked, tmpFile);
                }
                if (mimeTypeChecked.equals("application/pdf")) {
                    return destinationFolder.createExternalPDFFileItem(name, description, mimeTypeChecked, tmpFile);
                }
                if (mimeTypeChecked.equals("text/uri-list")) {
                    return destinationFolder.createExternalUrlItem(name, description, tmpFile);
                }
                return destinationFolder.createExternalFileItem(name, description, mimeTypeChecked, tmpFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destinationFolder.createExternalFileItem(name, description, mimeType, tmpFile);
    }

    public static File getTmpFile(InputStream in) {
        File tempFile;
        block20: {
            tempFile = null;
            try {
                try {
                    tempFile = File.createTempFile("tempfile", ".tmp");
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileOutputStream out = new FileOutputStream(tempFile);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("tmp: " + tempFile.getAbsolutePath());
        return tempFile;
    }

    public static ACLType getACLTypeByKey(List<String> list) {
        switch (list.get(0)) {
            case "jcr:read": {
                return ACLType.READ_ONLY;
            }
            case "jcr:write": {
                return ACLType.WRITE_OWNER;
            }
            case "hl:writeAll": {
                return ACLType.WRITE_ALL;
            }
            case "jcr:all": {
                return ACLType.ADMINISTRATOR;
            }
        }
        return ACLType.READ_ONLY;
    }
}

