/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtil {
    protected static Logger logger = LoggerFactory.getLogger(WorkspaceUtil.class);
    private static final String READ_ONLY = "jcr:read";
    private static final String WRITE_OWNER = "jcr:write";
    private static final String WRITE_ALL = "hl:writeAll";
    private static final String ADMINISTRATOR = "jcr:all";

    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = null;
        try {
            name = folder.getUniqueName(initialName, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = initialName;
        }
        return name;
    }

    public static String getCopyName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = null;
        try {
            name = folder.getUniqueName(initialName, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = initialName;
        }
        return name;
    }

    public static String returnThreeDigitNo(int number) {
        String threeDigitNo = null;
        int length = String.valueOf(number).length();
        if (length == 1) {
            threeDigitNo = "00" + number;
        }
        if (length == 2) {
            threeDigitNo = "0" + number;
        }
        if (length == 3) {
            threeDigitNo = "" + number;
        }
        return threeDigitNo;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, String storageId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalFileItem(name, description, mimeType, storageId);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        File tmpFile = null;
        try {
            String mimeTypeChecked;
            tmpFile = WorkspaceUtil.getTmpFile(is);
            if (mimeType == null) {
                try {
                    mimeType = MimeTypeUtil.getMimeType(name, tmpFile);
                }
                catch (Exception e) {
                    logger.error("Error getting mimeType of " + name);
                }
            }
            if ((mimeTypeChecked = mimeType) != null) {
                if (mimeTypeChecked.startsWith("image")) {
                    return destinationFolder.createExternalImageItem(name, description, mimeTypeChecked, tmpFile);
                }
                if (mimeTypeChecked.equals("application/pdf")) {
                    return destinationFolder.createExternalPDFFileItem(name, description, mimeTypeChecked, tmpFile);
                }
                if (mimeTypeChecked.equals("text/uri-list")) {
                    return destinationFolder.createExternalUrlItem(name, description, tmpFile);
                }
                return destinationFolder.createExternalFileItem(name, description, mimeTypeChecked, tmpFile);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return destinationFolder.createExternalFileItem(name, description, mimeType, tmpFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTmpFile(InputStream in) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempfile", ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("inpustream already closed");
            }
        }
        return tempFile;
    }

    public static ACLType getACLTypeByKey(List<String> list) {
        switch (list.get(0)) {
            case "jcr:read": {
                return ACLType.READ_ONLY;
            }
            case "jcr:write": {
                return ACLType.WRITE_OWNER;
            }
            case "hl:writeAll": {
                return ACLType.WRITE_ALL;
            }
            case "jcr:all": {
                return ACLType.ADMINISTRATOR;
            }
        }
        return ACLType.READ_ONLY;
    }

    public static List<String> getMembersByGroup(String id) throws InternalErrorException {
        UserManager um = HomeLibrary.getHomeManagerFactory().getUserManager();
        GCubeGroup group = null;
        List<String> members = null;
        try {
            group = um.getGroup(id);
            members = group.getMembers();
        }
        catch (Exception e) {
            throw new InternalErrorException(id + " is not a valid groupId", e);
        }
        return members;
    }
}

