/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

public class FileSystemNameUtil {
    public static final char[] FILE_NAME_ILLEGAL_CHARACTERS;
    public static final char DEFAULT_REPLACE_CHAR = '_';
    public static final String[] INVALID_FILE_NAME;
    public static final String[] WINDOWS_INVALID_FILE_NAME;
    public static final String REPLACE_NAME = "no-name";

    static {
        char[] cArray = new char[15];
        cArray[0] = 60;
        cArray[1] = 62;
        cArray[2] = 58;
        cArray[3] = 34;
        cArray[4] = 47;
        cArray[5] = 92;
        cArray[6] = 124;
        cArray[7] = 63;
        cArray[8] = 42;
        cArray[9] = 10;
        cArray[10] = 13;
        cArray[11] = 9;
        cArray[13] = 12;
        cArray[14] = 96;
        FILE_NAME_ILLEGAL_CHARACTERS = cArray;
        INVALID_FILE_NAME = new String[]{"..", "."};
        WINDOWS_INVALID_FILE_NAME = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    }

    public static String cleanFileName(String name) {
        String cleanedName = FileSystemNameUtil.removeInvalidChars(name);
        cleanedName = FileSystemNameUtil.replaceInvalidName(cleanedName);
        return cleanedName;
    }

    protected static String removeInvalidChars(String name) {
        char[] cArray = FILE_NAME_ILLEGAL_CHARACTERS;
        int n = FILE_NAME_ILLEGAL_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char invalidChar = cArray[n2];
            name = name.replace(invalidChar, '_');
            ++n2;
        }
        return name;
    }

    protected static String replaceInvalidName(String name) {
        String invalidName;
        String[] stringArray = INVALID_FILE_NAME;
        int n = INVALID_FILE_NAME.length;
        int n2 = 0;
        while (n2 < n) {
            invalidName = stringArray[n2];
            if (name.equals(invalidName)) {
                return REPLACE_NAME;
            }
            ++n2;
        }
        stringArray = WINDOWS_INVALID_FILE_NAME;
        n = WINDOWS_INVALID_FILE_NAME.length;
        n2 = 0;
        while (n2 < n) {
            invalidName = stringArray[n2];
            if (name.equals(invalidName)) {
                return REPLACE_NAME;
            }
            ++n2;
        }
        return name;
    }
}

