/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipModelWriter {
    protected Logger logger = LoggerFactory.getLogger(ZipModelWriter.class);

    public File writeItem(ZipItem item, boolean skipRoot) throws IOException {
        File zipFile = File.createTempFile("zippping", "gz");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        this.addZipItem(out, item, skipRoot);
        out.close();
        return zipFile;
    }

    protected void addZipItem(ZipOutputStream zos, ZipItem item, boolean skipRoot) throws IOException {
        switch (item.getType()) {
            case FILE: {
                this.addZipFile(zos, (ZipFile)item, skipRoot);
                break;
            }
            case FOLDER: {
                this.addZipFolder(zos, (ZipFolder)item, skipRoot);
            }
        }
    }

    protected void addZipFolder(ZipOutputStream zos, ZipFolder folder, boolean skipRoot) throws IOException {
        if (folder.getChildren().size() == 0) {
            ZipEntry zipEntry = null;
            if (skipRoot) {
                String sub = folder.getPath().substring(folder.getPath().indexOf(47) + 1);
                int start = sub.indexOf(47) + 1;
                this.logger.trace("adding ZipFile path: " + folder.getPath().substring(start));
                zipEntry = new ZipEntry(String.valueOf(folder.getPath().substring(start)) + "/");
            } else {
                this.logger.trace("adding ZipFile path: " + folder.getPath());
                zipEntry = new ZipEntry(String.valueOf(folder.getPath()) + "/");
            }
            zos.putNextEntry(zipEntry);
            zos.closeEntry();
        }
        for (ZipItem item : folder.getChildren()) {
            this.addZipItem(zos, item, skipRoot);
        }
    }

    protected void addZipFile(ZipOutputStream zos, ZipFile file, boolean flag) throws IOException {
        ZipEntry zipEntry = null;
        if (flag) {
            String sub = file.getPath().substring(file.getPath().indexOf(47) + 1);
            int start = sub.indexOf(47) + 1;
            this.logger.trace("adding ZipFile path: " + file.getPath().substring(start));
            zipEntry = new ZipEntry(file.getPath().substring(start));
        } else {
            this.logger.trace("adding ZipFile path: " + file.getPath());
            zipEntry = new ZipEntry(file.getPath());
        }
        zipEntry.setComment(file.getComment());
        zipEntry.setExtra(file.getExtra());
        zos.putNextEntry(zipEntry);
        InputStream stream = file.getContentStream();
        IOUtils.copy((InputStream)stream, (OutputStream)zos);
        zos.closeEntry();
        stream.close();
    }
}

