/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.config.easyconf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.beanutils.ConfigurationDynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.homelibrary.util.config.easyconf.AggregatedProperties;
import org.gcube.common.homelibrary.util.config.easyconf.ClasspathUtil;
import org.gcube.common.homelibrary.util.config.easyconf.Filter;

public class ComponentProperties {
    public static final String NULL_STRING = null;
    private static final Log log = LogFactory.getLog(ComponentProperties.class);
    AggregatedProperties properties;

    ComponentProperties(AggregatedProperties conf) {
        this.properties = conf;
        this.setThrowExceptionOnMissing(false);
    }

    public Map toMap() {
        return ConfigurationConverter.getMap((Configuration)this.properties);
    }

    public DynaBean toDynaBean() {
        return new ConfigurationDynaBean((Configuration)this.properties);
    }

    public Configuration toConfiguration() {
        return this.properties;
    }

    public DataConfiguration toDataConfiguration() {
        return new DataConfiguration((Configuration)this.properties);
    }

    public Properties getProperties() {
        return ConfigurationConverter.getProperties((Configuration)this.properties);
    }

    public Object getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this.properties)).equals(obj);
    }

    public Iterator getKeys() {
        return this.properties.getKeys();
    }

    public Iterator getKeys(String prefix) {
        return this.properties.getKeys(prefix);
    }

    public int hashCode() {
        return ((Object)((Object)this.properties)).hashCode();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public void setProperty(String key, Object value) {
        this.properties.setProperty(key, value);
    }

    public Configuration subset(String prefix) {
        return this.properties.subset(prefix);
    }

    public String toString() {
        return ((Object)((Object)this.properties)).toString();
    }

    public BigDecimal getBigDecimal(String key) {
        return this.properties.getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.properties.getBigDecimal(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key, Filter filter) {
        BigDecimal value = this.getBigDecimal(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public BigDecimal getBigDecimal(String key, Filter filter, BigDecimal defaultValue) {
        return (BigDecimal)this.getPropertyWithFilter(key, filter, BigDecimal.class, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.properties.getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.properties.getBigInteger(key, defaultValue);
    }

    public BigInteger getBigInteger(String key, Filter filter) {
        BigInteger value = this.getBigInteger(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public BigInteger getBigInteger(String key, Filter filter, BigInteger defaultValue) {
        return (BigInteger)this.getPropertyWithFilter(key, filter, BigInteger.class, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.properties.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.properties.getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) throws NoClassDefFoundError {
        return this.properties.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key, Filter filter) {
        Boolean value = this.getBoolean(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public Boolean getBoolean(String key, Filter filter, Boolean defaultValue) throws NoClassDefFoundError {
        return (Boolean)this.getPropertyWithFilter(key, filter, Boolean.class, defaultValue);
    }

    public boolean getBoolean(String key, Filter filter, boolean defaultValue) {
        return this.getBoolean(key, filter, new Boolean(defaultValue));
    }

    public byte getByte(String key) {
        return this.properties.getByte(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.properties.getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.properties.getByte(key, defaultValue);
    }

    public byte getByte(String key, Filter filter) {
        Byte value = this.getByte(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public Byte getByte(String key, Filter filter, Byte defaultValue) {
        return (Byte)this.getPropertyWithFilter(key, filter, Byte.class, defaultValue);
    }

    public byte getByte(String key, Filter filter, byte defaultValue) {
        return this.getByte(key, filter, new Byte(defaultValue));
    }

    public double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.properties.getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.properties.getDouble(key, defaultValue);
    }

    public double getDouble(String key, Filter filter) {
        Double value = this.getDouble(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public Double getDouble(String key, Filter filter, Double defaultValue) {
        return (Double)this.getPropertyWithFilter(key, filter, Double.class, defaultValue);
    }

    public double getDouble(String key, Filter filter, double defaultValue) {
        return this.getDouble(key, filter, new Double(defaultValue));
    }

    public Class getClass(String key) throws ClassNotFoundException {
        String className = this.getString(key);
        return ClasspathUtil.locateClass(className);
    }

    public Class getClass(String key, Class defaultValue) throws ClassNotFoundException {
        String defaultStringValue = null;
        String className = this.getString(key, defaultStringValue);
        if (className == defaultStringValue) {
            return defaultValue;
        }
        return ClasspathUtil.locateClass(className);
    }

    public Class getClass(String key, Filter filter) throws ClassNotFoundException {
        String className = this.getString(key, filter);
        return ClasspathUtil.locateClass(className);
    }

    public Class getClass(String key, Filter filter, Class defaultValue) throws ClassNotFoundException {
        Object defaultStringValue = null;
        String className = this.getString(key, filter, null);
        if (className == defaultStringValue) {
            return defaultValue;
        }
        return ClasspathUtil.locateClass(className);
    }

    public Class[] getClassArray(String key) throws ClassNotFoundException {
        String[] classNames = this.getStringArray(key);
        return ClasspathUtil.locateClasses(classNames);
    }

    public Class[] getClassArray(String key, Class[] defaultValue) throws ClassNotFoundException {
        String[] defaultStringArrayValue = null;
        String[] classNames = this.getStringArray(key, defaultStringArrayValue);
        if (classNames == defaultStringArrayValue) {
            return defaultValue;
        }
        return ClasspathUtil.locateClasses(classNames);
    }

    public Class[] getClassArray(String key, Filter filter) throws ClassNotFoundException {
        String[] classNames = this.getStringArray(key, filter);
        return ClasspathUtil.locateClasses(classNames);
    }

    public Class[] getClassArray(String key, Filter filter, Class[] defaultValue) throws ClassNotFoundException {
        String[] defaultStringArrayValue = null;
        String[] classNames = this.getStringArray(key, filter, defaultStringArrayValue);
        if (classNames == defaultStringArrayValue) {
            return defaultValue;
        }
        return ClasspathUtil.locateClasses(classNames);
    }

    public float getFloat(String key) {
        return this.properties.getFloat(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.properties.getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.properties.getFloat(key, defaultValue);
    }

    public float getFloat(String key, Filter filter) {
        Float value = this.getFloat(key, filter, null);
        this.validateValue(key, value);
        return value.floatValue();
    }

    public Float getFloat(String key, Filter filter, Float defaultValue) {
        return (Float)this.getPropertyWithFilter(key, filter, Float.class, defaultValue);
    }

    public float getFloat(String key, Filter filter, float defaultValue) {
        return this.getFloat(key, filter, new Float(defaultValue)).floatValue();
    }

    public int getInt(String key) {
        return this.properties.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.properties.getInt(key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.properties.getInteger(key, defaultValue);
    }

    public int getInt(String key, Filter filter) {
        Integer value = this.getInteger(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public Integer getInteger(String key, Filter filter, Integer defaultValue) {
        return (Integer)this.getPropertyWithFilter(key, filter, Integer.class, defaultValue);
    }

    public int getInt(String key, Filter filter, int defaultValue) {
        return this.getInteger(key, filter, new Integer(defaultValue));
    }

    public List getList(String key) {
        return this.properties.getList(key);
    }

    public List getList(String key, List defaultValue) {
        return this.properties.getList(key, defaultValue);
    }

    public List getList(String key, Filter filter) {
        List value = (List)this.getPropertyWithFilter(key, filter, List.class, null);
        this.validateValue(key, value);
        if (value == null) {
            value = Collections.EMPTY_LIST;
        }
        return value;
    }

    public List getList(String key, Filter filter, List defaultValue) {
        return (List)this.getPropertyWithFilter(key, filter, List.class, defaultValue);
    }

    public long getLong(String key) {
        return this.properties.getLong(key);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.properties.getLong(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.properties.getLong(key, defaultValue);
    }

    public long getLong(String key, Filter filter) {
        Long value = this.getLong(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public Long getLong(String key, Filter filter, Long defaultValue) {
        return (Long)this.getPropertyWithFilter(key, filter, Long.class, defaultValue);
    }

    public long getLong(String key, Filter filter, long defaultValue) {
        return this.getLong(key, filter, new Long(defaultValue));
    }

    public short getShort(String key) {
        return this.properties.getShort(key);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.properties.getShort(key, defaultValue);
    }

    public short getShort(String key, short defaultValue) {
        return this.properties.getShort(key, defaultValue);
    }

    public short getShort(String key, Filter filter) {
        Short value = this.getShort(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public Short getShort(String key, Filter filter, Short defaultValue) {
        return (Short)this.getPropertyWithFilter(key, filter, Short.class, defaultValue);
    }

    public short getShort(String key, Filter filter, short defaultValue) {
        return this.getShort(key, filter, new Short(defaultValue));
    }

    public String getString(String key) {
        Object value = this.properties.getProperty(key);
        String result = value instanceof List ? this.listToString((List)value) : this.properties.getString(key);
        return result;
    }

    public String getString(String key, String defaultValue) {
        return this.properties.getString(key, defaultValue);
    }

    public String getString(String key, Filter filter) {
        String value = this.getString(key, filter, null);
        this.validateValue(key, value);
        return value;
    }

    public String getString(String key, Filter filter, String defaultValue) {
        return (String)this.getPropertyWithFilter(key, filter, String.class, defaultValue);
    }

    public String[] getStringArray(String key) {
        return this.properties.getStringArray(key);
    }

    public String[] getStringArray(String key, Filter filter) {
        List value = this.getList(key, filter);
        return value.toArray(new String[0]);
    }

    public String[] getStringArray(String key, Filter filter, String[] defaultValue) {
        List value;
        List<String> defaultList = null;
        if (defaultValue != null) {
            defaultList = Arrays.asList(defaultValue);
        }
        if ((value = this.getList(key, filter, defaultList)) == null) {
            return null;
        }
        return value.toArray(new String[0]);
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        List value;
        List<String> defaultList = null;
        if (defaultValue != null) {
            defaultList = Arrays.asList(defaultValue);
        }
        if ((value = this.getList(key, defaultList)) == null) {
            return null;
        }
        return value.toArray(new String[0]);
    }

    public boolean hasBaseConfiguration() {
        return this.properties.hasBaseConfiguration();
    }

    public List getLoadedSources() {
        return this.properties.loadedSources();
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.properties.setThrowExceptionOnMissing(throwExceptionOnMissing);
    }

    public boolean isThrowExceptionOnMissing() {
        return this.properties.isThrowExceptionOnMissing();
    }

    public Long getDelayPeriod() {
        Long nullLong = null;
        return this.getLong("easyconf:reload-delay", nullLong);
    }

    public String getComponentName() {
        return this.properties.getComponentName();
    }

    protected Object getPropertyWithFilter(String key, Filter filter, Class theClass, Object defaultValue) {
        AggregatedProperties filteredConf = this.properties;
        Object value = null;
        for (int i = filter.numOfSelectors(); i >= 0 && value == null; --i) {
            MapConfiguration varsConf = null;
            if (filter.hasVariables()) {
                varsConf = new MapConfiguration(filter.getVariables());
                filteredConf = new CompositeConfiguration();
                filteredConf.addConfiguration((Configuration)varsConf);
                filteredConf.addConfiguration((Configuration)this.properties);
            }
            value = ComponentProperties.getTypedPropertyWithDefault(key + filter.getFilterSuffix(i), theClass, (Configuration)filteredConf, null);
            if (varsConf != null) {
                this.properties.removeConfiguration((Configuration)varsConf);
            }
            log.debug((Object)("Value for " + key + filter.getFilterSuffix(i) + "=" + value));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected static Object getTypedPropertyWithDefault(String key, Class theClass, Configuration properties, Object defaultValue) {
        if (theClass.equals(Float.class)) {
            return properties.getFloat(key, (Float)defaultValue);
        }
        if (theClass.equals(Integer.class)) {
            return properties.getInteger(key, (Integer)defaultValue);
        }
        if (theClass.equals(String.class)) {
            return properties.getString(key, (String)defaultValue);
        }
        if (theClass.equals(Double.class)) {
            return properties.getDouble(key, (Double)defaultValue);
        }
        if (theClass.equals(Long.class)) {
            return properties.getLong(key, (Long)defaultValue);
        }
        if (theClass.equals(Boolean.class)) {
            return properties.getBoolean(key, (Boolean)defaultValue);
        }
        if (theClass.equals(List.class)) {
            return properties.getList(key, (List)defaultValue);
        }
        if (theClass.equals(BigInteger.class)) {
            return properties.getBigInteger(key, (BigInteger)defaultValue);
        }
        if (theClass.equals(BigDecimal.class)) {
            return properties.getBigDecimal(key, (BigDecimal)defaultValue);
        }
        if (theClass.equals(Byte.class)) {
            return properties.getByte(key, (Byte)defaultValue);
        }
        if (theClass.equals(Short.class)) {
            return properties.getShort(key, (Short)defaultValue);
        }
        throw new IllegalArgumentException("Class " + theClass + " is not" + "supported for properties");
    }

    protected void validateValue(String key, Object value) {
        if (value == null && this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException("Property with key=" + key + " was not found");
        }
    }

    protected String listToString(List list) {
        StringBuffer property = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            property.append(String.valueOf(it.next()));
            if (!it.hasNext()) continue;
            property.append(",");
        }
        return property.toString();
    }
}

