/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.performance.tool;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.homelibrary.performance.tool.MeasurementChannel;
import org.gcube.common.homelibrary.performance.tool.MeasurementData;

public class MeasurementSession {
    protected String name;
    protected Map<String, MeasurementChannel> channels;
    protected Map<Long, Map<String, MeasurementData>> measureData;
    protected long currentValue;

    public MeasurementSession(String name) {
        this.name = name;
        this.channels = new LinkedHashMap<String, MeasurementChannel>();
        this.measureData = new LinkedHashMap<Long, Map<String, MeasurementData>>();
    }

    protected long getCurrentValue() {
        return this.currentValue;
    }

    protected void addData(String channelName, MeasurementData data) {
        Map<String, MeasurementData> measure = this.getCurrentValueData();
        measure.put(channelName, data);
    }

    protected Map<String, MeasurementData> getCurrentValueData() {
        LinkedHashMap<String, MeasurementData> measure = null;
        if (!this.measureData.containsKey(this.currentValue)) {
            measure = new LinkedHashMap();
            this.measureData.put(this.currentValue, measure);
        } else {
            measure = this.measureData.get(this.currentValue);
        }
        return measure;
    }

    public void startMeasure(long value) {
        this.currentValue = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MeasurementChannel getChannel(String name) {
        if (this.channels.containsKey(name)) {
            return this.channels.get(name);
        }
        MeasurementChannel channel = new MeasurementChannel(name, this);
        this.channels.put(name, channel);
        return channel;
    }

    public List<MeasurementChannel> getChannels() {
        return new LinkedList<MeasurementChannel>(this.channels.values());
    }

    public void setChannels(Map<String, MeasurementChannel> channels) {
        this.channels = channels;
    }

    public Set<Long> getValues() {
        return this.measureData.keySet();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MeasurementSession [channels=");
        builder.append(this.channels);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }
}

