/**
 * 
 */
package org.gcube.common.homelibrary.home.workspace.folder.items;

import java.io.InputStream;
import java.util.List;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;

/**
 * @author Valentina Marioli valentina.marioli@isti.cnr.it
 *
 */
public interface ExternalFile extends FolderItem, File {
	
	/**
	 * Set Data
	 * @param data an inputstream
	 * @throws InternalErrorException
	 */
	void setData(InputStream data) throws InternalErrorException;
	/**
	 * Get a list of versions
	 * @return a list of versions
	 * @throws InternalErrorException
	 */
	public List<String> getVersionHistory() throws InternalErrorException;

	/**
	 * Restore a version
	 * @param version a previous version 
	 * @throws InternalErrorException
	 */
	public void restoreVersion(String version) throws InternalErrorException;

	
	/**
	 * Remove a version
	 * @param version a previous version 
	 * @throws InternalErrorException
	 */
	public void removeVersion(String version) throws InternalErrorException;
	
	/**
	 * Get Current version
	 * @return the current version
	 * @throws InternalErrorException
	 */
	public String getVersion() throws InternalErrorException;
	
	/**
	 * Get a previous version
	 * @return the current version
	 * @throws InternalErrorException
	 */
	public InputStream downloadVersion(String version) throws InternalErrorException;
}
