package org.gcube.homelibrary.fs.model.items;

import java.util.Calendar;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import org.gcube.homelibrary.fs.model.annotations.Attribute;
import org.gcube.homelibrary.fs.model.annotations.NodeAttribute;
import org.gcube.homelibrary.fs.model.items.nodes.Accounting;
import org.gcube.homelibrary.fs.model.types.ItemAction;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class Item {
	
	String id;

	String name;
	
	String path;
	
	String parentId;

	String parentPath;
	
	String primaryType;

	boolean locked;

	@Attribute("jcr:title")
	String title;

	@Attribute("jcr:description")
	String description;

	@Attribute("jcr:lastModifiedBy")
	String lastModifiedBy;

	@Attribute("jcr:lastModified")
	Calendar lastModificationTime;

	@Attribute("jcr:created")
	Calendar creationTime;

	@Attribute("hl:portalLogin")
	String owner;

	@Attribute("hl:lastAction")
	ItemAction lastAction;

	/*
	@XmlElement
	boolean trashed;

	@XmlElement
	boolean shared;

	*/

	@Attribute("hl:hidden")
	boolean hidden;
	
	@NodeAttribute("hl:accounting")
	Accounting accounting;

	//List <AccountingDelegate> accounting;

}
