/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.homelibrary.fs.model;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Path {
    protected List<String> paths = null;

    private Path() {
    }

    protected Path(String path) {
        if (path != null && !path.isEmpty()) {
            this.paths = Arrays.asList(path.split("/")).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
    }

    public String toPath() {
        if (this.paths == null || this.paths.isEmpty()) {
            return "/";
        }
        return "/" + this.paths.stream().collect(Collectors.joining("/")) + "/";
    }

    public String getLastDirName() {
        return this.paths.get(this.paths.size() - 1);
    }

    protected Path append(Path anotherPath) {
        Path path = new Path();
        path.paths = new LinkedList<String>(this.paths);
        if (anotherPath.paths != null) {
            path.paths.addAll(anotherPath.paths);
        }
        return path;
    }

    protected Path append(String anotherPath) {
        return this.append(new Path(anotherPath));
    }

    protected Path remove(Path anotherPath) {
        Path path = new Path();
        path.paths = new LinkedList<String>(this.paths);
        path.paths.removeAll(anotherPath.paths);
        return path;
    }
}

