/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.gcube.common.keycloak.DefaultKeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.KeycloakClientLegacyIS;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.TokenIntrospectionResponse;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class DefaultKeycloakClientLegacyIS
extends DefaultKeycloakClient
implements KeycloakClientLegacyIS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findTokenEndpointURL() throws KeycloakClientException {
        logger.debug("Checking ScopeProvider's scope presence and format");
        String originalScope = ScopeProvider.instance.get();
        if (originalScope == null || !originalScope.startsWith("/") || originalScope.length() < 2) {
            throw new KeycloakClientException(originalScope == null ? "Scope not found in ScopeProvider" : "Bad scope name found: " + originalScope);
        }
        logger.debug("Assuring use the rootVO to query the endpoint simple query. Actual scope is: {}", (Object)originalScope);
        String rootVOScope = "/" + originalScope.split("/")[1];
        logger.debug("Setting rootVO scope into provider as: {}", (Object)rootVOScope);
        List accessPoints = null;
        ScopeProvider scopeProvider = ScopeProvider.instance;
        synchronized (scopeProvider) {
            boolean scopeModified = false;
            if (!ScopeProvider.instance.get().equals(rootVOScope)) {
                logger.debug("Overriding scope in the provider with rootVO scope : {}", (Object)rootVOScope);
                ScopeProvider.instance.set(rootVOScope);
                scopeModified = true;
            }
            logger.debug("Creating simple query");
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", "Auth")).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", "IAM")).setResult(String.format("$resource/Profile/AccessPoint[Description/text() eq '%s']", "oidc-token endpoint"));
            logger.debug("Creating client for AccessPoint");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            logger.trace("Submitting query: {}", (Object)query);
            accessPoints = client.submit((Query)query);
            if (scopeModified) {
                logger.debug("Resetting scope into provider to the original value: {}", (Object)originalScope);
                ScopeProvider.instance.set(originalScope);
            }
        }
        if (accessPoints.size() == 0) {
            throw new KeycloakClientException("Service endpoint not found");
        }
        if (accessPoints.size() > 1) {
            throw new KeycloakClientException("Found more than one endpoint with query");
        }
        String address = ((ServiceEndpoint.AccessPoint)accessPoints.iterator().next()).address();
        logger.debug("Found address: {}", (Object)address);
        try {
            return new URL(address);
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot create URL from address: " + address, (Throwable)e);
        }
    }

    @Override
    public URL computeIntrospectionEndpointURL() throws KeycloakClientException {
        return this.computeIntrospectionEndpointURL(this.findTokenEndpointURL());
    }

    @Override
    public TokenResponse queryOIDCToken(String clientId, String clientSecret) throws KeycloakClientException {
        return this.queryOIDCToken(this.findTokenEndpointURL(), clientId, clientSecret);
    }

    @Override
    public TokenResponse queryUMAToken(String clientId, String clientSecret, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(clientId, clientSecret, ScopeProvider.instance.get(), permissions);
    }

    @Override
    public TokenResponse queryUMAToken(TokenResponse oidcTokenResponse, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.findTokenEndpointURL(), this.constructBeareAuthenticationHeader(oidcTokenResponse), audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.findTokenEndpointURL(), clientId, clientSecret, audience, permissions);
    }

    @Override
    public TokenResponse refreshToken(TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken((String)null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String clientId, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(clientId, null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(this.findTokenEndpointURL(), clientId, clientSecret, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String refreshTokenJWTString) throws KeycloakClientException {
        try {
            String clientId = ModelUtils.getClientIdFromToken((AccessToken)ModelUtils.getRefreshTokenFrom((String)refreshTokenJWTString));
            return this.refreshToken(clientId, refreshTokenJWTString);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct access token object from token response", (Throwable)e);
        }
    }

    @Override
    public TokenResponse refreshToken(String clientId, String refreshTokenJWTString) throws KeycloakClientException {
        return this.refreshToken(clientId, null, refreshTokenJWTString);
    }

    @Override
    public TokenResponse refreshToken(String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        return this.refreshToken(this.findTokenEndpointURL(), clientId, clientSecret, refreshTokenJWTString);
    }

    @Override
    public TokenIntrospectionResponse introspectAccessToken(String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.introspectAccessToken(this.computeIntrospectionEndpointURL(), clientId, clientSecret, accessTokenJWTString);
    }

    @Override
    public boolean isAccessTokenVerified(String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.isAccessTokenVerified(this.computeIntrospectionEndpointURL(), clientId, clientSecret, accessTokenJWTString);
    }
}

