/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gcube.common.gxrest.request.GXHTTPStringRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.TokenIntrospectionResponse;
import org.gcube.common.keycloak.model.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKeycloakClient
implements KeycloakClient {
    protected static Logger logger = LoggerFactory.getLogger(KeycloakClient.class);
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String D4S_CONTEXT_HEADER_NAME = "X-D4Science-Context";
    public static final String BASE_URL = "https://url.d4science.org/auth/realms/";

    @Override
    public URL getRealmBaseURL(String context) throws KeycloakClientException {
        return this.getRealmBaseURL(context, "d4science");
    }

    @Override
    public URL getRealmBaseURL(String context, String realm) throws KeycloakClientException {
        String urlString = BASE_URL + realm + "/";
        if (!context.startsWith("/d4science.research-infrastructures.eu")) {
            String root = context.split("/")[1];
            urlString = urlString.replace("url", "url." + root.replaceAll("\\.", "-"));
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            logger.warn("Cannot create base URL from string: {}", (Object)urlString, (Object)e);
            return null;
        }
    }

    @Override
    public URL getTokenEndpointURL(URL realmBaseURL) throws KeycloakClientException {
        logger.debug("Constructing token endpoint URL starting from base URL: {}", (Object)realmBaseURL);
        try {
            URL tokenURL = null;
            tokenURL = realmBaseURL.getPath().endsWith("/") ? new URL(realmBaseURL, "protocol/openid-connect/token") : new URL(realmBaseURL.toString() + "/" + "protocol/openid-connect" + "/" + "token");
            logger.debug("Constructed token URL is: {}", (Object)tokenURL);
            return tokenURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot constructs toke URL from base URL: " + realmBaseURL, e);
        }
    }

    @Override
    public URL getIntrospectionEndpointURL(URL realmBaseURL) throws KeycloakClientException {
        logger.debug("Constructing introspection URL starting from base URL: {}", (Object)realmBaseURL);
        try {
            URL tokenURL = null;
            tokenURL = realmBaseURL.getPath().endsWith("/") ? new URL(realmBaseURL, "protocol/openid-connect/token/introspect") : new URL(realmBaseURL.toString() + "/" + "protocol/openid-connect" + "/" + "token" + "/" + "introspect");
            logger.debug("Constructed introspection URL is: {}", (Object)tokenURL);
            return tokenURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot constructs toke URL from base URL: " + realmBaseURL, e);
        }
    }

    @Override
    public URL computeIntrospectionEndpointURL(URL tokenEndpointURL) throws KeycloakClientException {
        logger.debug("Computing introspection endpoint URL starting from token endpoint URL: {}", (Object)tokenEndpointURL);
        try {
            URL introspectionURL = null;
            introspectionURL = tokenEndpointURL.getPath().endsWith("token/") ? new URL(tokenEndpointURL, "introspect") : new URL(tokenEndpointURL, "token/introspect");
            logger.debug("Computed introspection URL is: {}", (Object)introspectionURL);
            return introspectionURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot compute introspection URL from token URL: " + tokenEndpointURL, e);
        }
    }

    @Override
    public TokenResponse queryOIDCToken(String context, String clientId, String clientSecret) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(context, clientId, clientSecret, null);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(String context, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.queryOIDCToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret);
    }

    @Override
    public TokenResponse queryOIDCToken(URL tokenURL, String clientId, String clientSecret) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, clientId, clientSecret, null);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(URL tokenURL, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, this.constructBasicAuthenticationHeader(clientId, clientSecret), audience);
    }

    protected String constructBasicAuthenticationHeader(String clientId, String clientSecret) {
        return "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
    }

    @Override
    public TokenResponse queryOIDCToken(String context, String authorization) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(context, authorization, null);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(String context, String authorization, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, audience);
    }

    @Override
    public TokenResponse queryOIDCToken(URL tokenURL, String authorization) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, authorization, null);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(URL tokenURL, String authorization, String audience) throws KeycloakClientException {
        logger.debug("Querying OIDC token from Keycloak server with URL: {}", (Object)tokenURL);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("client_credentials"));
        HashMap<String, String> headers = new HashMap<String, String>();
        logger.debug("Adding authorization header as: {}", (Object)authorization);
        headers.put(AUTHORIZATION_HEADER, authorization);
        if (audience != null) {
            logger.debug("Adding d4s context header as: {}", (Object)audience);
            headers.put(D4S_CONTEXT_HEADER_NAME, audience);
        }
        return this.performRequest(tokenURL, headers, params);
    }

    @Override
    public TokenResponse queryUMAToken(String context, TokenResponse oidcTokenResponse, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), oidcTokenResponse, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, TokenResponse oidcTokenResponse, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(tokenURL, this.constructBeareAuthenticationHeader(oidcTokenResponse), audience, permissions);
    }

    protected String constructBeareAuthenticationHeader(TokenResponse oidcTokenResponse) {
        return "Bearer " + oidcTokenResponse.getAccessToken();
    }

    @Override
    public TokenResponse queryUMAToken(String context, String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(tokenURL, this.constructBasicAuthenticationHeader(clientId, clientSecret), audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(String context, String authorization, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, String authorization, String audience, List<String> permissions) throws KeycloakClientException {
        if (audience == null || "".equals(audience)) {
            throw new KeycloakClientException("Audience must be not null nor empty");
        }
        logger.debug("Querying UMA token from Keycloak server with URL: {}", (Object)tokenURL);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("urn:ietf:params:oauth:grant-type:uma-ticket"));
        try {
            params.put("audience", Arrays.asList(URLEncoder.encode(DefaultKeycloakClient.checkAudience(audience), "UTF-8")));
            logger.trace("audience is {}", (Object)DefaultKeycloakClient.checkAudience(audience));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Can't URL encode audience: {}", (Object)audience, (Object)e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        logger.debug("Adding authorization header as: {}", (Object)authorization);
        headers.put(AUTHORIZATION_HEADER, authorization);
        if (permissions != null && !permissions.isEmpty()) {
            params.put("permission", permissions.stream().map(s -> {
                try {
                    return URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return "";
                }
            }).collect(Collectors.toList()));
        }
        return this.performRequest(tokenURL, headers, params);
    }

    protected TokenResponse performRequest(URL tokenURL, Map<String, String> headers, Map<String, List<String>> params) throws KeycloakClientException {
        GXInboundResponse response;
        GXHTTPStringRequest request;
        if (tokenURL == null) {
            throw new KeycloakClientException("Token URL must be not null");
        }
        if (!headers.containsKey(AUTHORIZATION_HEADER) || "".equals(headers.get(AUTHORIZATION_HEADER))) {
            throw new KeycloakClientException("Authorization must be not null nor empty");
        }
        try {
            String queryString = params.entrySet().stream().flatMap(p -> ((List)p.getValue()).stream().map(v -> (String)p.getKey() + "=" + v)).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            logger.trace("query string is {}", (Object)queryString);
            request = GXHTTPStringRequest.newRequest((String)tokenURL.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
            logger.trace("Adding provided headers: {}", headers);
            for (String headerName : headers.keySet()) {
                request.header(headerName, headers.get(headerName));
            }
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct the request object correctly", e);
        }
        try {
            response = request.post();
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot send request correctly", e);
        }
        if (response.isSuccessResponse()) {
            try {
                return (TokenResponse)response.tryConvertStreamedContentFromJson(TokenResponse.class);
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct token response object correctly", e);
            }
        }
        String errorBody = "[empty]";
        try {
            errorBody = response.getStreamedContentAsString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw KeycloakClientException.create("Unable to get token", response.getHTTPCode(), response.getHeaderFields().getOrDefault("content-type", Collections.singletonList("unknown/unknown")).get(0), errorBody);
    }

    private static String checkAudience(String audience) {
        if (audience.startsWith("/")) {
            try {
                logger.trace("Audience was provided in non URL encoded form, encoding it");
                return URLEncoder.encode(audience, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Cannot URL encode 'audience'", (Throwable)e);
            }
        }
        return audience;
    }

    @Override
    public TokenResponse refreshToken(String context, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(tokenURL, null, null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String context, String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        if (clientId == null) {
            logger.debug("Client id not set, trying to get it from access token info");
            try {
                clientId = ModelUtils.getClientIdFromToken(ModelUtils.getAccessTokenFrom(tokenResponse));
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct access token object from token response", e);
            }
        }
        return this.refreshToken(tokenURL, clientId, clientSecret, tokenResponse.getRefreshToken());
    }

    @Override
    public TokenResponse refreshToken(String context, String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        return this.refreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, refreshTokenJWTString);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        GXInboundResponse response;
        GXHTTPStringRequest request;
        if (tokenURL == null) {
            throw new KeycloakClientException("Token URL must be not null");
        }
        if (clientId == null || "".equals(clientId)) {
            throw new KeycloakClientException("Client id must be not null nor empty");
        }
        if (refreshTokenJWTString == null || "".equals(clientId)) {
            throw new KeycloakClientException("Refresh token JWT encoded string must be not null nor empty");
        }
        logger.debug("Refreshing token from Keycloak server with URL: {}", (Object)tokenURL);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "refresh_token");
            params.put("refresh_token", refreshTokenJWTString);
            params.put("client_id", URLEncoder.encode(clientId, "UTF-8"));
            if (clientSecret != null && !"".equals(clientSecret)) {
                params.put("client_secret", URLEncoder.encode(clientSecret, "UTF-8"));
            }
            String queryString = params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            request = GXHTTPStringRequest.newRequest((String)tokenURL.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct the request object correctly", e);
        }
        try {
            response = request.post();
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot send request correctly", e);
        }
        if (response.isSuccessResponse()) {
            try {
                return (TokenResponse)response.tryConvertStreamedContentFromJson(TokenResponse.class);
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct token response object correctly", e);
            }
        }
        throw KeycloakClientException.create("Unable to refresh token", response.getHTTPCode(), response.getHeaderFields().getOrDefault("content-type", Collections.singletonList("unknown/unknown")).get(0), response.getMessage());
    }

    @Override
    public TokenIntrospectionResponse introspectAccessToken(String context, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.introspectAccessToken(this.getIntrospectionEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, accessTokenJWTString);
    }

    @Override
    public TokenIntrospectionResponse introspectAccessToken(URL introspectionURL, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        GXInboundResponse response;
        GXHTTPStringRequest request;
        if (introspectionURL == null) {
            throw new KeycloakClientException("Introspection URL must be not null");
        }
        if (clientId == null || "".equals(clientId)) {
            throw new KeycloakClientException("Client id must be not null nor empty");
        }
        if (clientSecret == null || "".equals(clientSecret)) {
            throw new KeycloakClientException("Client secret must be not null nor empty");
        }
        logger.debug("Verifying access token against Keycloak server with URL: {}", (Object)introspectionURL);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("token", accessTokenJWTString);
            String queryString = params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            request = GXHTTPStringRequest.newRequest((String)introspectionURL.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
            request = request.header(AUTHORIZATION_HEADER, this.constructBasicAuthenticationHeader(clientId, clientSecret));
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct the request object correctly", e);
        }
        try {
            response = request.post();
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot send request correctly", e);
        }
        if (response.isSuccessResponse()) {
            try {
                return (TokenIntrospectionResponse)response.tryConvertStreamedContentFromJson(TokenIntrospectionResponse.class);
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct introspection response object correctly", e);
            }
        }
        throw KeycloakClientException.create("Unable to get token introspection response", response.getHTTPCode(), response.getHeaderFields().getOrDefault("content-type", Collections.singletonList("unknown/unknown")).get(0), response.getMessage());
    }

    @Override
    public boolean isAccessTokenVerified(String context, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.isAccessTokenVerified(this.getIntrospectionEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, accessTokenJWTString);
    }

    @Override
    public boolean isAccessTokenVerified(URL introspectionURL, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.introspectAccessToken(introspectionURL, clientId, clientSecret, accessTokenJWTString).getActive();
    }
}

