/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakClientHelper {
    protected static Logger logger = LoggerFactory.getLogger(KeycloakClientHelper.class);
    private static String GATEWAY_CLIENT_ID = "d4science-internal-gateway";

    public static void setDefaultGWClientID(String gatewayClientId) {
        logger.warn("The default GW clientId will be changed to: {}", (Object)gatewayClientId);
        GATEWAY_CLIENT_ID = gatewayClientId;
    }

    public static TokenResponse getTokenForUser(String context, String username, String password) throws KeycloakClientException {
        logger.debug("Getting new token for user '{}' in context '{}'", (Object)username, (Object)context);
        logger.trace("Getting OIDC token for user '{}' using configured default GW clientId '{}'", (Object)username, (Object)GATEWAY_CLIENT_ID);
        TokenResponse oidcTR = KeycloakClientFactory.newInstance().queryOIDCTokenOfUser(context, GATEWAY_CLIENT_ID, "", username, password);
        logger.trace("Getting UMA token in the '{}' context", (Object)context);
        return KeycloakClientFactory.newInstance().queryUMAToken(context, oidcTR, context, null);
    }
}

