/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.metadataprofilediscovery.reader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.metadataprofilediscovery.jaxb.MetadataField;
import org.gcube.common.metadataprofilediscovery.jaxb.MetadataFormat;
import org.gcube.common.metadataprofilediscovery.reader.MetadataProfileNotFoundException;
import org.gcube.common.metadataprofilediscovery.reader.QueryForResourceUtil;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MetadataFormatReader {
    private static Logger logger = LoggerFactory.getLogger(MetadataFormatReader.class);
    private ScopeBean scope;
    private MetadataFormat metadataFormat;
    private String resourceID;

    public MetadataFormatReader(ScopeBean scope, String resourceID) throws Exception {
        this.scope = scope;
        this.resourceID = resourceID;
        this.metadataFormat = this.getMetadataFormatByResourceID(resourceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataFormat getMetadataFormatByResourceID(String resourceID) throws Exception {
        logger.trace("Getting MedataFormat for resourceID: " + resourceID);
        if (this.scope == null) {
            throw new Exception("Scope is null");
        }
        String scopeString = this.scope.toString();
        logger.trace("read scope: " + scopeString);
        MetadataFormat mf = new MetadataFormat();
        try {
            logger.info("Using scope from ScopeProvider: " + scopeString);
            String queryString = QueryForResourceUtil.queryForGenericResourceById(resourceID);
            logger.trace("queryString: " + queryString);
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            List appProfile = client.submit((Query)q);
            if (appProfile == null || appProfile.size() == 0) {
                throw new MetadataProfileNotFoundException("Your resourceID " + resourceID + " is not registered in the infrastructure, the scope is " + scopeString);
            }
            String theResource = null;
            try {
                theResource = (String)appProfile.get(0);
                logger.debug("Resource (Metadata Format) with resourceID " + resourceID + " found");
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(theResource))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                logger.debug("Unmarshalling it..");
                mf = this.getMetadataFormatFromResource(helper);
                String metadataSource = this.getMetadataFormatSourceFromResource(helper);
                mf.setMetadataSource(metadataSource);
            }
            catch (Exception e) {
                logger.error("Error while parsing Resource " + theResource + " from the infrastructure, the scope is " + scopeString, (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to fetch resourceID " + resourceID + " from the infrastructure, the scope is " + scopeString, (Throwable)e);
            MetadataFormat metadataFormat = mf;
            return metadataFormat;
        }
        return mf;
    }

    private String getMetadataFormatSourceFromResource(XPathHelper helper) throws Exception {
        try {
            List metadataFormatSource = helper.evaluate("/Resource/Profile/Body/metadataformat");
            if (metadataFormatSource == null || metadataFormatSource.isEmpty()) {
                throw new Exception("metadataformat not found in the body, consider to add <metadataformat>");
            }
            return (String)metadataFormatSource.get(0);
        }
        catch (Exception e) {
            logger.error("An error occurred in getMetadataFormatSourceFromResource ", (Throwable)e);
            return null;
        }
    }

    private MetadataFormat getMetadataFormatFromResource(XPathHelper helper) throws Exception {
        try {
            List metadataFormatSource = helper.evaluate("/Resource/Profile/Body/metadataformat");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetadataFormat.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            if (metadataFormatSource == null || metadataFormatSource.size() == 0) {
                throw new Exception("Resource does not contain <metadataformat> in the body");
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(((String)metadataFormatSource.get(0)).getBytes());
            MetadataFormat mtdf = (MetadataFormat)jaxbUnmarshaller.unmarshal((InputStream)stream);
            logger.debug("returning metadata format with medata type: " + mtdf.getType());
            return mtdf;
        }
        catch (Exception e) {
            logger.error("An error occurred in getMetadataFormatSourceFromResource ", (Throwable)e);
            return null;
        }
    }

    private List<MetadataField> getMetadataFieldsFromResource(XPathHelper helper) throws Exception {
        try {
            List metadatafields = helper.evaluate("/Resource/Profile/Body/metadataformat/metadatafield");
            if (metadatafields == null || metadatafields.isEmpty()) {
                throw new Exception("Metadata fields not found");
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetadataField.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ArrayList<MetadataField> mfs = new ArrayList<MetadataField>();
            logger.debug("MetadataFields are: " + metadatafields.size());
            for (String mfield : metadatafields) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(mfield.getBytes());
                    MetadataField mtdf = (MetadataField)jaxbUnmarshaller.unmarshal((InputStream)stream);
                    logger.debug("Unmarshalled: " + mtdf);
                    mfs.add(mtdf);
                }
                catch (Exception e) {
                    logger.error("An error occurred during unmarshall performing on " + mfield + ", skipping this metadatafield");
                }
            }
            return mfs;
        }
        catch (Exception e) {
            logger.error("An error occurred in getMetadataFieldsFromResource ", (Throwable)e);
            return null;
        }
    }

    public ScopeBean getScope() {
        return this.scope;
    }

    public MetadataFormat getMetadataFormat() {
        return this.metadataFormat;
    }

    public String getResourceID() {
        return this.resourceID;
    }
}

