/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.metadataprofilediscovery.reader;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.metadataprofilediscovery.bean.MetadataProfile;
import org.gcube.common.metadataprofilediscovery.reader.MetadataProfileNotFoundException;
import org.gcube.common.metadataprofilediscovery.reader.QueryForResourceUtil;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MetadataFormatDiscovery {
    private static Logger logger = LoggerFactory.getLogger(MetadataFormatDiscovery.class);
    private String secondaryType;
    private ScopeBean scope;
    private List<MetadataProfile> metadataProfiles;
    private String resourceName;

    public MetadataFormatDiscovery(ScopeBean scope, String secondaryType, String resourceName) throws Exception {
        this.scope = scope;
        this.secondaryType = secondaryType;
        this.resourceName = resourceName;
        this.metadataProfiles = this.readMetadataProfilesFromInfrastrucure();
    }

    private List<MetadataProfile> readMetadataProfilesFromInfrastrucure() throws Exception {
        logger.trace("read secondary type: " + this.secondaryType);
        if (this.scope == null) {
            throw new Exception("Scope is null");
        }
        String scopeString = this.scope.toString();
        logger.trace("read scope: " + scopeString);
        ArrayList<MetadataProfile> list = new ArrayList<MetadataProfile>();
        try {
            logger.info("Using scope from ScopeProvider: " + scopeString);
            String queryString = null;
            queryString = this.resourceName != null ? QueryForResourceUtil.getGcubeGenericQueryStringForSecondaryTypeAndName(this.resourceName, this.secondaryType) : QueryForResourceUtil.getGcubeGenericQueryStringForSecondaryType(this.secondaryType);
            logger.trace("queryString: " + queryString);
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            List metaProfile = client.submit((Query)q);
            if (metaProfile == null || metaProfile.size() == 0) {
                throw new MetadataProfileNotFoundException("Resource/s with secondaryType: " + this.secondaryType + " is/are not registered in the scope: " + scopeString);
            }
            for (String elem : metaProfile) {
                try {
                    DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = docBuilder.parse(new InputSource(new StringReader(elem)));
                    Element node = doc.getDocumentElement();
                    XPathHelper helper = new XPathHelper((Node)node);
                    MetadataProfile meta = this.getMetadataProfileFromResource(doc, helper);
                    list.add(meta);
                }
                catch (Exception e) {
                    logger.error("Error while trying to fetch resource with secondary type " + this.secondaryType + " from the infrastructure, scope: " + scopeString, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to fetch applicationProfile " + this.secondaryType + " from the infrastructure, " + e);
            return list;
        }
        return list;
    }

    private MetadataProfile getMetadataProfileFromResource(Document doc, XPathHelper helper) throws MetadataProfileNotFoundException {
        try {
            MetadataProfile metadataProfile = new MetadataProfile();
            List id = helper.evaluate("/Resource/ID/text()");
            if (id == null || id.isEmpty()) {
                throw new MetadataProfileNotFoundException("Resource ID not found for " + helper.toString());
            }
            metadataProfile.setId((String)id.get(0));
            List name = helper.evaluate("/Resource/Profile/Name/text()");
            if (name == null || name.isEmpty()) {
                throw new MetadataProfileNotFoundException("Resource Name not found for Resource Id: " + metadataProfile.getId());
            }
            metadataProfile.setName((String)name.get(0));
            logger.info("Building Profile for Resource Name: " + metadataProfile.getName());
            List description = helper.evaluate("/Resource/Profile/Description/text()");
            if (description == null || description.isEmpty()) {
                logger.info("Description not found for Resource ID: " + metadataProfile.getId() + ", continuing.. ");
            } else {
                metadataProfile.setDescription((String)description.get(0));
            }
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr = xpath.compile("/Resource/Profile/Body/metadataformat/@type");
            String metadataType = (String)expr.evaluate(doc, XPathConstants.STRING);
            if (metadataType == null || metadataType.isEmpty()) {
                throw new MetadataProfileNotFoundException("Required attribute 'type' not found in the element 'metadataformat' for Metadata Profile (within Resource) Id: " + metadataProfile.getId());
            }
            metadataProfile.setMetadataType(metadataType);
            return metadataProfile;
        }
        catch (Exception e) {
            logger.error("An error occurred in getMetadataProfileFromResource ", (Throwable)e);
            return null;
        }
    }

    public String getSecondaryType() {
        return this.secondaryType;
    }

    public ScopeBean getScope() {
        return this.scope;
    }

    public List<MetadataProfile> getMetadataProfiles() {
        return this.metadataProfiles;
    }
}

