/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.oidc.keycloak.d4science;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ExportParser {
    private ArrayNode rootNode;

    public ExportParser(FileInputStream exportFileFIS) throws SAXException, IOException, ParserConfigurationException {
        ObjectMapper objectMapper = new ObjectMapper();
        this.rootNode = (ArrayNode)objectMapper.readTree((InputStream)exportFileFIS);
    }

    public Map<String, String> getAllUsersAndAvatars() {
        TreeMap<String, String> users = new TreeMap<String, String>();
        Iterator arrayIterator = this.rootNode.elements();
        while (arrayIterator.hasNext()) {
            JsonNode entry = (JsonNode)arrayIterator.next();
            users.put(entry.get("username").asText(), entry.get("avatarURL").asText());
        }
        return users;
    }

    public Set<String> getAllContexts() {
        TreeSet<String> distinctContexts = new TreeSet<String>();
        Iterator arrayIterator = this.rootNode.elements();
        while (arrayIterator.hasNext()) {
            JsonNode entry = (JsonNode)arrayIterator.next();
            ObjectNode contextsNode = (ObjectNode)entry.get("contexts");
            contextsNode.fieldNames().forEachRemaining(f -> distinctContexts.add((String)f));
        }
        return distinctContexts;
    }

    public Map<String, Set<String>> getContextsAndRoles(String user) {
        Iterator arrayIterator = this.rootNode.elements();
        while (arrayIterator.hasNext()) {
            JsonNode entry = (JsonNode)arrayIterator.next();
            String username = entry.get("username").asText();
            if (!user.equals(username)) continue;
            TreeMap<String, Set<String>> contextAndRoles = new TreeMap<String, Set<String>>();
            ObjectNode contextsNode = (ObjectNode)entry.get("contexts");
            Iterator contextIterator = contextsNode.fieldNames();
            while (contextIterator.hasNext()) {
                String context = (String)contextIterator.next();
                TreeSet roles = new TreeSet();
                ArrayNode rolesNodes = (ArrayNode)contextsNode.get(context);
                rolesNodes.elements().forEachRemaining(r -> roles.add(r.asText()));
                contextAndRoles.put(context, roles);
            }
            return contextAndRoles;
        }
        return Collections.emptyMap();
    }

    public Map<String, Map<String, Set<String>>> getAllUserContextsAndRoles() {
        TreeMap<String, Map<String, Set<String>>> usersToContextAndRoles = new TreeMap<String, Map<String, Set<String>>>();
        Iterator arrayIterator = this.rootNode.elements();
        while (arrayIterator.hasNext()) {
            JsonNode entry = (JsonNode)arrayIterator.next();
            String username = entry.get("username").asText();
            TreeMap contextAndRoles = new TreeMap();
            ObjectNode contextsNode = (ObjectNode)entry.get("contexts");
            Iterator contextIterator = contextsNode.fieldNames();
            while (contextIterator.hasNext()) {
                String context = (String)contextIterator.next();
                TreeSet roles = new TreeSet();
                ArrayNode rolesNodes = (ArrayNode)contextsNode.get(context);
                rolesNodes.elements().forEachRemaining(r -> roles.add(r.asText()));
                contextAndRoles.put(context, roles);
            }
            usersToContextAndRoles.put(username, contextAndRoles);
        }
        return usersToContextAndRoles;
    }
}

