/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.oidc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.oidc.AbstractOIDCToSitesAndRolesMapper;
import org.gcube.oidc.Site;
import org.gcube.oidc.SitesMapperExecption;

public class SlashSeparatedContextMapper
extends AbstractOIDCToSitesAndRolesMapper {
    private static final String SPLIT_REGEXP = "/";
    private static final int MINIMUM_TOKENS = 2;
    private static final int EMPTY_TOKEN_INDEX = 0;
    private static final int ROOT_VO_TOKEN_INDEX = 1;
    private static final int VO_TOKEN_INDEX = 2;
    private static final int VRE_TOKEN_INDEX = 3;

    public SlashSeparatedContextMapper(Map<String, List<String>> resourceName2AccessRoles) {
        super(resourceName2AccessRoles);
    }

    @Override
    public Site map(String rootSite) throws SitesMapperExecption {
        ArrayList sites = new ArrayList(this.resourceName2AccessRoles.keySet());
        Collections.sort(sites);
        Site gwSitesTree = null;
        for (String site : sites) {
            logger.info("Checking site: " + site);
            List roles = (List)this.resourceName2AccessRoles.get(site);
            if (logger.isDebugEnabled()) {
                logger.debug("Roles for site are: " + roles);
            }
            String[] siteTokens = site.split(SPLIT_REGEXP);
            if (logger.isDebugEnabled()) {
                logger.debug("Tokens are: " + siteTokens.length);
            }
            if (siteTokens.length < 2) {
                throw new SitesMapperExecption("Found " + siteTokens.length + " tokens only. Minimum should be: " + 2);
            }
            String rootVO = siteTokens[1];
            if (logger.isDebugEnabled()) {
                logger.debug("Root VO is: " + rootVO);
            }
            if (!rootSite.equals(rootVO)) {
                logger.info("Skipping evaluation of site tree not belonging to this Root VO: " + rootVO);
                continue;
            }
            logger.info("Site belongs to this Root VO");
            if (siteTokens.length >= 3) {
                if (gwSitesTree == null) {
                    logger.warn(rootVO + " Root VO's permissions are not set for user");
                    gwSitesTree = new Site(rootVO, null);
                }
                String vo = siteTokens[2];
                if (logger.isDebugEnabled()) {
                    logger.debug("VO is: " + vo);
                }
                if (siteTokens.length == 4) {
                    if (!gwSitesTree.getChildren().containsKey(vo)) {
                        logger.warn(vo + " VO's permissions are not set for user");
                        gwSitesTree.getChildren().put(vo, new Site(vo, null));
                    }
                    String vre = siteTokens[3];
                    if (logger.isDebugEnabled()) {
                        logger.debug("VRE is: " + vre);
                    }
                    logger.info("Adding leaf site: " + vre);
                    gwSitesTree.getChildren().get(vo).getChildren().put(vre, new Site(vre, roles));
                    continue;
                }
                if (gwSitesTree.getChildren().containsKey(vo)) continue;
                logger.info("Creating site for VO: " + vo);
                gwSitesTree.getChildren().put(vo, new Site(vo, roles));
                continue;
            }
            if (gwSitesTree == null) {
                logger.info("Creating site for Root VO: " + rootVO);
                gwSitesTree = new Site(rootVO, roles);
                continue;
            }
            if (gwSitesTree.getRoles() == null) {
                logger.info("Setting out of order roles for Root VO");
                continue;
            }
            logger.warn("Duplicated roles definition for Root VO");
        }
        return gwSitesTree;
    }
}

