/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.oidc.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTToken
implements Serializable {
    protected static Logger logger = LoggerFactory.getLogger(JWTToken.class);
    private static final long serialVersionUID = -7063122428186284827L;
    public static final String ACCOUNT_RESOURCE = "account";
    private String raw;
    private JSONObject token;
    private JSONObject payload;

    public static JWTToken fromString(String tokenString) {
        if (tokenString == null) {
            logger.debug("Token string is null, cannot create token object");
            return null;
        }
        try {
            return new JWTToken(tokenString);
        }
        catch (ParseException e) {
            logger.error("Cannot parse token string", (Throwable)e);
            return null;
        }
    }

    private JWTToken(String raw) throws ParseException {
        this.raw = raw;
        this.parse();
    }

    private void parse() throws ParseException {
        this.token = (JSONObject)new JSONParser().parse(this.raw);
        String[] parts = this.getAccessTokenString().split("\\.");
        this.payload = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(parts[1])));
    }

    public String getRaw() {
        return this.raw;
    }

    public String getAccessTokenString() {
        return (String)this.token.get((Object)"access_token");
    }

    public String getRefreshTokenString() {
        return (String)this.token.get((Object)"refresh_token");
    }

    public String getAsBearer() {
        return "Bearer " + this.getAccessTokenString();
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public String getAzp() {
        return (String)this.getPayload().get((Object)"azp");
    }

    public Long getExp() {
        return (Long)this.getPayload().get((Object)"exp");
    }

    public Date getExpAsDate() {
        return new Date(this.getExp() * 1000L);
    }

    public Calendar getExpAsCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getExpAsDate());
        return cal;
    }

    public boolean isExpired() {
        return new Date().after(this.getExpAsDate());
    }

    public List<String> getAud() {
        ArrayList<String> audienceStrings = new ArrayList<String>();
        Object audience = this.getPayload().get((Object)"aud");
        if (audience instanceof String) {
            audienceStrings.add((String)audience);
        } else if (audience instanceof JSONArray) {
            JSONArray audienceArray = (JSONArray)audience;
            for (int i = 0; i < audienceArray.size(); ++i) {
                audienceStrings.add((String)audienceArray.get(i));
            }
        }
        return audienceStrings;
    }

    public String getSub() {
        return (String)this.getPayload().get((Object)"sub");
    }

    public String getEmail() {
        return (String)this.getPayload().get((Object)"email");
    }

    public String getFamily() {
        return (String)this.getPayload().get((Object)"family_name");
    }

    public String getGiven() {
        return (String)this.getPayload().get((Object)"given_name");
    }

    public String getUserName() {
        return (String)this.getPayload().get((Object)"preferred_username");
    }

    public String getDisplayName() {
        return (String)this.getPayload().get((Object)"name");
    }

    protected JSONObject getResourceAccess() {
        return (JSONObject)this.getPayload().get((Object)"resource_access");
    }

    protected Iterator<String> getResourceAccessKeys() {
        return this.getResourceAccess().keySet().iterator();
    }

    public List<String> getResourceAccessRoles(String resource) {
        JSONArray rolesJsonArray = (JSONArray)((JSONObject)this.getResourceAccess().get((Object)resource)).get((Object)"roles");
        ArrayList<String> roles = new ArrayList<String>(rolesJsonArray.size());
        for (int i = 0; i < rolesJsonArray.size(); ++i) {
            roles.add((String)rolesJsonArray.get(i));
        }
        return roles;
    }

    public Map<String, List<String>> getResourceNameToAccessRolesMap(List<String> resourcesToSkip) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator<String> resourcesIterator = this.getResourceAccessKeys();
        while (resourcesIterator.hasNext()) {
            String resource = resourcesIterator.next();
            if (resourcesToSkip.contains(resource)) continue;
            map.put(resource, this.getResourceAccessRoles(resource));
        }
        return map;
    }

    protected JSONArray getAuthorizationPermissions() {
        JSONObject authorization = (JSONObject)this.getPayload().get((Object)"authorization");
        return (JSONArray)authorization.get((Object)"permissions");
    }

    public List<String> getAuthorizationPermissionRSNames() {
        ArrayList<String> permissionsRSName = new ArrayList<String>();
        JSONArray permissions = this.getAuthorizationPermissions();
        for (int i = 0; i < permissions.size(); ++i) {
            JSONObject permissionsEntry = (JSONObject)permissions.get(i);
            permissionsRSName.add((String)permissionsEntry.get((Object)"rsname"));
        }
        return permissionsRSName;
    }

    public List<String> getAuthorizationPermissionRSNameResourceScopes(String rsname) {
        ArrayList<String> scopes = new ArrayList<String>();
        JSONArray permissions = this.getAuthorizationPermissions();
        for (int i = 0; i < permissions.size(); ++i) {
            JSONArray scopesJsonArray;
            JSONObject permissionsEntry = (JSONObject)permissions.get(i);
            if (!rsname.equals(permissionsEntry.get((Object)"rsname")) || (scopesJsonArray = (JSONArray)permissionsEntry.get((Object)"resource_scopes")) == null) continue;
            for (int j = 0; j < scopesJsonArray.size(); ++j) {
                scopes.add((String)scopesJsonArray.get(j));
            }
        }
        return scopes;
    }

    public Map<String, List<String>> getAuthorizationPermissionRSNameToResourceScopesMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String aprn : this.getAuthorizationPermissionRSNames()) {
            map.put(aprn, this.getAuthorizationPermissionRSNameResourceScopes(aprn));
        }
        return map;
    }

    public String toString() {
        return this.getRaw();
    }
}

