package org.gcube.common.quota.defaults;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.gcube.common.quota.library.quotalist.CallerType;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.quotedefault.QuotaDefault;
import org.gcube.common.quota.library.quotedefault.QuotaDefaultList;
import org.gcube.common.quota.library.quotedefault.StorageQuotaDefault;
import org.gcube.common.quota.util.Constants;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationSystemQuery {

	private static Logger log = LoggerFactory
			.getLogger(InformationSystemQuery.class);

	private List<QuotaDefault> listQuotaDefault=new ArrayList<QuotaDefault>();


	/**
	 * Query at information System for retrive a list quote default
	 */
	public InformationSystemQuery(){
		SimpleQuery query = ICFactory.queryFor(GenericResource.class);
		query.addCondition(
				"$resource/Profile/SecondaryType/text() eq '"
						+ Constants.QUOTA_CATEGORY + "'")
						.addCondition(
								"$resource/Profile/Name/text() eq '"
										+ Constants.QUOTA_NAME + "'")
										.setResult("$resource");

		DiscoveryClient<GenericResource> client = ICFactory
				.clientFor(GenericResource.class);
		List<GenericResource> quotaResources = client.submit(query);
		QuotaDefaultList quotalist=null;
		if (quotaResources.size()>0){
			String resource=quotaResources.get(0).profile().bodyAsString();
			try {
			
				/*TODO DA ELIMINARE */
				/*
				java.io.StringWriter sw = new StringWriter();
				List<QuotaDefault> listQuotaTest=new ArrayList<QuotaDefault>();
				listQuotaTest.add(new StorageQuotaDefault(CallerType.USER,TimeInterval.DAILY,1.0));		
				QuotaDefaultList quoteDefault=new QuotaDefaultList();
				quoteDefault.setQuotaDefaultList(listQuotaTest);
				JAXBContext jaxbContextTest = JAXBContext.newInstance(QuotaDefaultList.class);
				Marshaller jaxbMarshaller = jaxbContextTest.createMarshaller();
				jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
				jaxbMarshaller.setProperty(Marshaller.JAXB_SCHEMA_LOCATION, "");
				jaxbMarshaller.marshal(quoteDefault, sw);
				log.debug("marshal:{}",sw);
				quotalist =  (QuotaDefaultList) jaxbContext.createUnmarshaller().unmarshal(new StringReader(sw.toString()));
				*/
				/*TODO FINO A QUI */	 

				JAXBContext jaxbContext = JAXBContext.newInstance(QuotaDefaultList.class);
				quotalist =  (QuotaDefaultList) jaxbContext.createUnmarshaller().unmarshal(new StringReader(resource.toString()));
				listQuotaDefault=quotalist.getQuotaDefaultList();				
				log.debug("From IS found a quota default:{}",quotalist.toString());

			}catch (Exception e) {
				log.error("--:{}",e.getLocalizedMessage());
				e.printStackTrace();
			}

		}
	}



	public List<QuotaDefault> getListQuotaDefault() {
		//TODO in development
		return listQuotaDefault;
	}
}
