package org.gcube.common.quota.service;

import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.common.quota.check.QuotaUsage;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.persistence.QuotaDBPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Query quota Status
 * @author Alessandro Pieve (alessandro.pieve@isti.cnr.it)
 *
 */
@Path("quotaStatus")
public class QuotaStatus {
	
	private static Logger log = LoggerFactory.getLogger(QuotaStatus.class);
	QuotaDBPersistence quotaPersistence=QuotaDBPersistence.getInstance();	
	
	
	@GET
	@Path("/detail/{identifier}")	
	@Produces(MediaType.APPLICATION_XML)
	public QuotaStorageStatus getQuotaStorageStatus(@NotNull @PathParam("identifier") String identifier,TimeInterval timeinterval) {
		QuotaUsage queryUsage =new QuotaUsage();
		QuotaStorageStatus quotaStorageStatus;
		try{
			log.info("retrieving quote for identifier:{} and time:{}",identifier,timeinterval.toString());
			quotaStorageStatus =queryUsage.selectStorageQuota(identifier,timeinterval);
			//TODO complete query for quota storage status
			//return quota;
		}catch(Exception e){
			throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST)
					.entity("Error : "+e.getMessage()).type(MediaType.TEXT_PLAIN).build()); 
		}
		return quotaStorageStatus;
	}

	
	
	

	
}


