package org.gcube.common.quota.check;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.common.quota.defaults.InformationSystemQuery;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.service.exception.NotFoundQuotaExecption;
import org.gcube.common.quota.util.DiscoveryListUser;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Quota check use a specify context 
 * Verify for context all quota inserted
 *  
 * @author Alessandro Pieve (alessandro.pieve@isti.cnr.it)
 *
 */
public class QuotaCheck {

	private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
	//private List<Quota> quoteCheck;
	//list a usage to be verified (generate from a list quote
	//private Map<String, Quota> quoteInsert = new HashMap<>();
	
	private String context=null;

	/**
	 * List quota for specify context
	 * @param context
	 * @throws NotFoundQuotaExecption
	 * @throws JSONException 
	 */
	public QuotaCheck(String context) throws NotFoundQuotaExecption{
		this.context=context;
	}
	public void getQuotaCheck() throws SQLException{

		log.info("QuotaCheck - init");
		//init a quota calculate Util
		QuotaCalculateUtil quotaUtility= new QuotaCalculateUtil(context);

		//create a list quota found on information System
		InformationSystemQuery informationSystemQuery =new InformationSystemQuery();
		log.debug("QuotaCheck - context:{}, setQuoteDefault:{}",context,informationSystemQuery.getListQuotaDefault());
		
		//set quota utility with quota default found on is
		quotaUtility.setQuoteDefault(informationSystemQuery.getListQuotaDefault());
		
		//TODO verificare se non ho una quota di default la vado a verificare in locale da un file di properties
		if (quotaUtility.getQuoteDefault()==null){
			//DA completare
			//leggo il file da properties e lo setto come quota default 
			log.debug("QuotaCheck - No quota default found");		
		}
		
		//list of user for specify context
		DiscoveryListUser discoveryListUser= new DiscoveryListUser(this.context);	
		log.debug("QuotaCheck - for context:{} , list user:{}",context,discoveryListUser.getListUser());
		
		//verify for each user if have a specify quota and Overwrite if exist and traduce into object for query accounting
		quotaUtility.verifyListUser(discoveryListUser.getListUser());
		log.debug("QuotaCheck - quotaUtility.getUsageToBeVerified():{}",quotaUtility.getUsageToBeVerified());
		
		//init accounting Persistence
		AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
		List<UsageValue> quoteChecked=new ArrayList<UsageValue>();
		try {
			//da valutare il suo uso per come e' scritto adesso in realta quotechecked e' una copia dell'oggetto usagetoBeverified
			//pensare se e' corretto eliminare quoteChecked o separarlo direttamente nella chiamata getUsageValueQuotaTotal
			quoteChecked=apq.getUsageValueQuotaTotal(quotaUtility.getUsageToBeVerified());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//log.debug("return quota usageToBeVerified:{}",usageToBeVerified);
		log.debug("return quota usage:{}",quoteChecked);

		//UsageServiceValue [clz=class org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord, temporalConstraint=StartTime : 2015-05-01 10:11:30:870 UTC (1430475090870 millis), EndTime : 2017-01-23 10:11:30:870 UTC (1485166290870 millis), Aggregated DAILY, filtersValue=[FiltersValue [filters=[{ "serviceClass" : "DataAccess" }, { "serviceName" : "CkanConnector" }], d=null, orderingProperty=null], FiltersValue [filters=[{ "serviceClass" : "VREManagement" }], d=null, orderingProperty=null]], identifier=lucio.lelii, d=0.0, orderingProperty=null, context=gcube],
		//UsageStorageValue [clz=class org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord, temporalConstraint=null, identifier=giancarlo.panichi, d=0.0, orderingProperty=dataVolume, context=/gcube], 
		//UsageStorageValue [clz=class org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord, temporalConstraint=StartTime : 2015-05-01 10:11:30:875 UTC (1430475090875 millis), EndTime : 2016-12-18 10:11:30:875 UTC (1482055890875 millis), Aggregated DAILY, identifier=name.surname, d=-11.0, orderingProperty=dataVolume, context=/gcube]]
		
		//se e' un usage StorageValue senza temporalConstraint lo salvo in un db
		
		//quota total con i campi : 
		//user id /quota default/ quota usage
		//in questo caso elimino il precedente ed inserisco il nuovo sempre 

		//init a object quota usage
		QuotaUsage queryQuotaUsage =new QuotaUsage();
		
		for(UsageValue usageIndex:quotaUtility.getUsageToBeVerified()){
			String identifier =usageIndex.getIdentifier();
			Double quotaUsage =usageIndex.getD();
			if (usageIndex.getClz()==QuotaType.STORAGE.getQuotaTypeClass()){
				log.debug("save quota storage identifier:{},temporalConstraint:{}",identifier,usageIndex.getTemporalConstraint());
				QuotaUsageStorageValue usageStorVal=(QuotaUsageStorageValue) usageIndex;
				queryQuotaUsage.insertStorageQuota(identifier, usageStorVal.getdQuota(), quotaUsage,usageIndex.getTemporalConstraint());
			}
			if (usageIndex.getClz()==QuotaType.SERVICE.getQuotaTypeClass()){
				//TODO Completare il salvataggio nel caso dei service
				log.debug("save quota service");
				
				
				
			}
		}
		
		
		//TODO completare la sezione che verifica se la quota e' sforata ed inserisce la policy 
		log.debug("verify insert ");
		QuotaStorageStatus quotaStorageStatus =queryQuotaUsage.selectStorageQuota("lucio.lelii",TimeInterval.FOREVER);
		log.debug("verify insert quotaStorageStatus:{}",quotaStorageStatus.toString());
		
		
		//riflettere su cosa slavare nel db 
		//sia per lo storage che per i service
		//pensare poi che la gestione dei pacchetti per i service puo' essere problematica 
		//(problema visto con lucio che se un pacchetto contiene x e y  e un pacchetto contiene y e z e sfora 
		//salvare anche i service temporali 
		


		
		
		
		

		//save value into a database for consulting externaly widget

		//first problem how to save this quote and where...




		
		
		/*
		log.info("Checked quota:{}",quoteChecked);
		for(UsageValue usageValue:quoteChecked){
			//set in quota entity usageValue
			quotaPersistence.setUsageQuota(quoteInsert.get(usageValue.getIdentifier()),usageValue.getD());		

			log.info("For identifier:{} quota/usage is:{}/{}",usageValue.getIdentifier(),quoteInsert.get(usageValue.getIdentifier()),usageValue.getD());
			if (usageValue.getD()>quoteInsert.get(usageValue.getIdentifier()).getQuotaValue()){
				insertPolicyBlock(quoteInsert.get(usageValue.getIdentifier()));
			}
		}
		log.info("QuotaCheck end");
		 */
	}





}
