/*
 * Decompiled with CFR 0.152.
 */
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.tools.OperatorService;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorLister {
    private Map<String, Set<String>> signatureToOperators = new TreeMap<String, Set<String>>();
    private Class desiredSuperclass = Operator.class;
    private int minGroupSizeToDisplay = 1;

    public Set<String> getOperators(String signature) {
        Set<String> ops = this.signatureToOperators.get(signature);
        if (ops == null) {
            ops = new TreeSet<String>();
            this.signatureToOperators.put(signature, ops);
        }
        return ops;
    }

    public static String getShortName(Class c) {
        int colon = c.getName().lastIndexOf(46);
        if (colon != -1) {
            return c.getName().substring(colon + 1);
        }
        return c.getName();
    }

    public void run() {
        RapidMiner.init();
        System.out.println("Here we go.");
        for (String string : OperatorService.getOperatorNames()) {
            try {
                Operator op = OperatorService.createOperator(string);
                if (!op.getClass().getSuperclass().equals(this.desiredSuperclass)) continue;
                String signature = String.valueOf(this.toString(op.getInputClasses())) + "," + this.toString(op.getOutputClasses());
                this.getOperators(signature).add(op.getClass().getName());
            }
            catch (OperatorCreationException e) {
                System.out.println("Failed: " + string);
            }
        }
        System.out.println(String.valueOf(this.signatureToOperators.size()) + " signatures");
        for (Map.Entry entry : this.signatureToOperators.entrySet()) {
            Set allHits = (Set)entry.getValue();
            if (allHits.size() < this.minGroupSizeToDisplay) continue;
            System.out.println(String.valueOf((String)entry.getKey()) + " (" + allHits.size() + " operators):");
            for (String className : allHits) {
                System.out.println("   " + className);
            }
        }
    }

    public String toString(Class[] classes) {
        StringBuilder b = new StringBuilder();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(OperatorLister.getShortName(c));
            ++n2;
        }
        return "[" + b.toString() + "]";
    }

    public static void main(String[] argv) {
        new OperatorLister().run();
    }
}

