/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.Example2DataTableRowIterator;
import com.rapidminer.datatable.Example2DataTableRowWrapper;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableExampleSetAdapter
extends AbstractDataTable {
    private static final int DEFAULT_MAX_SIZE_FOR_SHUFFLED_SAMPLING = 100000;
    private ExampleSet exampleSet;
    private List<Attribute> allAttributes = new ArrayList<Attribute>();
    private int numberOfRegularAttributes = 0;
    private AttributeWeights weights = null;
    private Attribute idAttribute;

    public DataTableExampleSetAdapter(ExampleSet exampleSet, AttributeWeights weights) {
        super("Data Table");
        this.exampleSet = exampleSet;
        this.weights = weights;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.allAttributes.add(attribute);
        }
        this.idAttribute = exampleSet.getAttributes().getId();
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        while (s.hasNext()) {
            Attribute specialAttribute = s.next().getAttribute();
            if (this.idAttribute != null && this.idAttribute.getName().equals(specialAttribute.getName())) continue;
            this.allAttributes.add(specialAttribute);
        }
        this.numberOfRegularAttributes = exampleSet.getAttributes().size();
    }

    public DataTableExampleSetAdapter(DataTableExampleSetAdapter dataTableExampleSetAdapter) {
        super(dataTableExampleSetAdapter.getName());
        this.exampleSet = dataTableExampleSetAdapter.exampleSet;
        this.allAttributes = dataTableExampleSetAdapter.allAttributes;
        this.numberOfRegularAttributes = dataTableExampleSetAdapter.numberOfRegularAttributes;
        this.weights = dataTableExampleSetAdapter.weights;
        this.idAttribute = dataTableExampleSetAdapter.idAttribute;
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return this.allAttributes.size() - this.numberOfRegularAttributes;
    }

    @Override
    public boolean isSpecial(int index) {
        return index >= this.numberOfRegularAttributes;
    }

    @Override
    public boolean isNominal(int index) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.allAttributes.get(index).getValueType(), 1);
    }

    @Override
    public boolean isDate(int index) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.allAttributes.get(index).getValueType(), 10);
    }

    @Override
    public boolean isTime(int index) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.allAttributes.get(index).getValueType(), 11);
    }

    @Override
    public boolean isDateTime(int index) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.allAttributes.get(index).getValueType(), 9);
    }

    @Override
    public boolean isNumerical(int index) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.allAttributes.get(index).getValueType(), 2);
    }

    @Override
    public String mapIndex(int column, int value) {
        return this.allAttributes.get(column).getMapping().mapIndex(value);
    }

    @Override
    public int mapString(int column, String value) {
        return this.allAttributes.get(column).getMapping().mapString(value);
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.allAttributes.get(column).getMapping().size();
    }

    @Override
    public String getColumnName(int i) {
        return this.allAttributes.get(i).getName();
    }

    @Override
    public int getColumnIndex(String name) {
        int i = 0;
        while (i < this.allAttributes.size()) {
            if (this.allAttributes.get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return this.weights != null;
    }

    @Override
    public double getColumnWeight(int column) {
        if (this.weights == null) {
            return Double.NaN;
        }
        return this.weights.getWeight(this.getColumnName(column));
    }

    @Override
    public int getNumberOfColumns() {
        return this.allAttributes.size();
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTableExampleSetAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int index) {
        return new Example2DataTableRowWrapper(this.exampleSet.getExample(index), this.allAttributes, this.idAttribute);
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new Example2DataTableRowIterator(this.exampleSet.iterator(), this.allAttributes, this.idAttribute);
    }

    @Override
    public int getNumberOfRows() {
        return this.exampleSet.size();
    }

    @Override
    public DataTable sample(int newSize) {
        DataTableExampleSetAdapter result = new DataTableExampleSetAdapter(this);
        double ratio = (double)newSize / (double)this.getNumberOfRows();
        int maxNumberBeforeSampling = 100000;
        String maxString = System.getProperty("rapidminer.gui.max_statistics_rows");
        if (maxString != null) {
            try {
                maxNumberBeforeSampling = Integer.parseInt(maxString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ExampleSet exampleSet = null;
        if (this.getNumberOfRows() < maxNumberBeforeSampling) {
            exampleSet = new SplittedExampleSet(this.exampleSet, ratio, 1, -1);
            ((SplittedExampleSet)exampleSet).selectSingleSubset(0);
        } else {
            exampleSet = Tools.getLinearSubsetCopy(this.exampleSet, newSize, 0);
        }
        result.exampleSet = exampleSet;
        return result;
    }

    public static ExampleSet createExampleSetFromDataTable(DataTable table) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int i = 0;
        while (i < table.getNumberOfColumns()) {
            Attribute attribute;
            if (table.isDate(i)) {
                attribute = AttributeFactory.createAttribute(table.getColumnName(i), 10);
                attributes.add(attribute);
            } else if (table.isTime(i)) {
                attribute = AttributeFactory.createAttribute(table.getColumnName(i), 11);
                attributes.add(attribute);
            } else if (table.isDateTime(i)) {
                attribute = AttributeFactory.createAttribute(table.getColumnName(i), 9);
                attributes.add(attribute);
            } else if (table.isNominal(i)) {
                attribute = AttributeFactory.createAttribute(table.getColumnName(i), 1);
                attributes.add(attribute);
            } else {
                attribute = AttributeFactory.createAttribute(table.getColumnName(i), 4);
                attributes.add(attribute);
            }
            ++i;
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes);
        int i2 = 0;
        while (i2 < table.getNumberOfRows()) {
            DataTableRow row = table.getRow(i2);
            double[] values = new double[attributes.size()];
            int a = 0;
            while (a < values.length) {
                Attribute attribute = (Attribute)attributes.get(a);
                values[a] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9) ? row.getValue(a) : (attribute.isNominal() ? (double)attribute.getMapping().mapString(table.getValueAsString(row, a)) : row.getValue(a));
                ++a;
            }
            exampleTable.addDataRow(new DoubleArrayDataRow(values));
            ++i2;
        }
        return exampleTable.createExampleSet();
    }
}

