/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.BugReport;
import com.rapidminer.tools.Tools;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;

public class BugAssistant
extends JDialog {
    private static final long serialVersionUID = 8379605320787188372L;
    private static final String INSTRUCTIONS = "<html><h4>Send Bug Report</h4>This dialog will help you to file a bug report. It will automatically collect most of the data necessary to examine the problem. The assistant will create a zip file containing your process setup (xml file), parameter settings, log file, and information about the runtime environment. RapidMiner does <i>not</i> automatically add data files or any other files since these may contain confidential data and may be large. You can attach them using the \"Add file...\" button. When you are done, save the bug report to disc and send it by email to</p><center><b><tt>request@rapid-i.com</tt></b></center>";
    private static final String TEXT_INSTRUCTIONS = "Enter a brief description of what happened into this text field. Please also describe the purpose of your process definition because this cannot always be concluded trivially from the process setup.";
    private JTextArea message = new JTextArea("Enter a brief description of what happened into this text field. Please also describe the purpose of your process definition because this cannot always be concluded trivially from the process setup.", 5, 20);
    private JTextComponent name = new JTextField(15);
    private JList attachments = new JList(new DefaultListModel());

    public BugAssistant(final Throwable exception) {
        super(RapidMinerGUI.getMainFrame(), "Bug Report Assistant", true);
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 0;
        JLabel instructions = new JLabel(INSTRUCTIONS);
        instructions.setFont(instructions.getFont().deriveFont(0));
        gbl.setConstraints(instructions, c);
        this.getContentPane().add(instructions);
        JLabel nameLabel = new JLabel("Your email address");
        c.gridwidth = 1;
        gbl.setConstraints(nameLabel, c);
        this.getContentPane().add(nameLabel);
        c.gridwidth = 0;
        gbl.setConstraints(this.name, c);
        this.getContentPane().add(this.name);
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        ExtendedJScrollPane messagePane = new ExtendedJScrollPane(this.message);
        c.gridwidth = 0;
        c.weighty = 5.0;
        gbl.setConstraints(messagePane, c);
        this.getContentPane().add(messagePane);
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 2;
        this.attachments.setSelectionMode(0);
        JScrollPane attachmentPane = new JScrollPane(this.attachments);
        gbl.setConstraints(attachmentPane, c);
        this.getContentPane().add(attachmentPane);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 3;
        JButton add = new JButton("Add file...");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile(null, null, true, null, null);
                if (file != null) {
                    ((DefaultListModel)BugAssistant.this.attachments.getModel()).addElement(file);
                }
            }
        });
        gbl.setConstraints(add, c);
        this.getContentPane().add(add);
        c.gridx = 1;
        c.gridy = 4;
        JButton remove = new JButton("Remove file");
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BugAssistant.this.attachments.getSelectedIndex() >= 0) {
                    ((DefaultListModel)BugAssistant.this.attachments.getModel()).remove(BugAssistant.this.attachments.getSelectedIndex());
                }
            }
        });
        gbl.setConstraints(remove, c);
        this.getContentPane().add(remove);
        c.gridwidth = 0;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 3;
        JButton save = new JButton("Save Report...");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String email = BugAssistant.this.name.getText().trim();
                if (email.length() == 0) {
                    JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), "Please enter an email address.", "Form incomplete", 0);
                    return;
                }
                File file = SwingTools.chooseFile(null, new File("bugreport.zip"), false, false, ".zip", "zip archives");
                if (file != null) {
                    try {
                        ListModel model = BugAssistant.this.attachments.getModel();
                        File[] attachments = new File[model.getSize()];
                        int i = 0;
                        while (i < attachments.length) {
                            attachments[i] = (File)model.getElementAt(i);
                            ++i;
                        }
                        BugReport.createBugReport(file, exception, "From: " + BugAssistant.this.name.getText() + Tools.getLineSeparator() + "Date: " + new Date() + Tools.getLineSeparator() + Tools.getLineSeparator() + BugAssistant.this.message.getText(), RapidMinerGUI.getMainFrame().getProcess(), RapidMinerGUI.getMainFrame().getMessageViewer().getLogMessage(), attachments);
                        BugAssistant.this.dispose();
                    }
                    catch (Throwable t) {
                        SwingTools.showSimpleErrorMessage("Cannot create report file!", t);
                    }
                }
            }
        });
        gbl.setConstraints(save, c);
        this.getContentPane().add(save);
        c.gridx = 2;
        c.gridy = 4;
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BugAssistant.this.dispose();
            }
        });
        gbl.setConstraints(cancel, c);
        this.getContentPane().add(cancel);
        this.pack();
        this.message.setSelectionStart(0);
        this.message.setSelectionEnd(TEXT_INSTRUCTIONS.length() - 1);
        this.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
    }

    public Dimension getPreferredSize() {
        return new Dimension(RapidMinerGUI.getMainFrame().getWidth() * 3 / 4, RapidMinerGUI.getMainFrame().getHeight() * 3 / 4);
    }
}

