/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;

public class InitialSettingsDialog
extends JDialog {
    private static final long serialVersionUID = 784141258768877739L;
    private static final String ICON_NAME = "folder.png";
    private static Icon openIcon = null;
    private JTextField workspaceField = new JTextField();
    private JComboBox lookAndFeelBox = new JComboBox<String>(RapidMinerGUI.LOOK_AND_FEELS);
    private File forbiddenDirectory;
    private boolean ok = false;

    static {
        openIcon = SwingTools.createIcon("24/folder.png");
    }

    public InitialSettingsDialog(Frame owner, File oldWorkspace, String defaultWorkspaceName, String workspaceText, File forbiddenDirectory, int defaultLookAndFeel, boolean showLookAndFeelSelection) {
        super(owner);
        this.forbiddenDirectory = forbiddenDirectory;
        this.setTitle("Select Workspace");
        SwingTools.setDialogIcon(this);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        Box mainPanel = new Box(1);
        JPanel workspacePanel = new JPanel();
        workspacePanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        GridBagLayout layout = new GridBagLayout();
        workspacePanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        String usedWorkspaceText = workspaceText;
        if (usedWorkspaceText == null) {
            usedWorkspaceText = "Please select a workspace directory. You should ensure that you can write into this directory. Please note that a set of initial sample process setups will be copied into this workspace directory. Hence, an existing directory named 'sample' in your workspace directory will be overwritten.";
        }
        JTextArea introText = new JTextArea(usedWorkspaceText, 4, 40);
        introText.setLineWrap(true);
        introText.setWrapStyleWord(true);
        introText.setEditable(false);
        introText.setBackground(workspacePanel.getBackground());
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(introText, c);
        workspacePanel.add(introText);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        if (oldWorkspace != null) {
            this.workspaceField.setText(oldWorkspace.getAbsolutePath());
        } else {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            File workspaceProposal = new File(fsv.getDefaultDirectory(), defaultWorkspaceName);
            this.workspaceField.setText(workspaceProposal.getAbsolutePath());
        }
        layout.setConstraints(this.workspaceField, c);
        workspacePanel.add(this.workspaceField);
        JButton fileButton = null;
        fileButton = openIcon != null ? new JButton(openIcon) : new JButton("...");
        fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file;
                File currentFile = null;
                String currentFilePath = InitialSettingsDialog.this.workspaceField.getText();
                if (currentFilePath != null && currentFilePath.length() > 0) {
                    currentFile = new File(currentFilePath);
                }
                if ((file = SwingTools.chooseFile(null, currentFile, true, true, null, null)) != null) {
                    InitialSettingsDialog.this.workspaceField.setText(file.getAbsolutePath());
                }
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(fileButton, c);
        workspacePanel.add(fileButton);
        mainPanel.add(workspacePanel);
        if (showLookAndFeelSelection) {
            if (defaultLookAndFeel >= 0) {
                this.lookAndFeelBox.setSelectedIndex(defaultLookAndFeel);
            }
            JPanel lookAndFeelPanel = new JPanel();
            lookAndFeelPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            GridBagLayout plafLayout = new GridBagLayout();
            lookAndFeelPanel.setLayout(plafLayout);
            GridBagConstraints plafC = new GridBagConstraints();
            plafC.fill = 1;
            plafC.insets = new Insets(4, 4, 4, 4);
            JTextArea lookAndFeelText = new JTextArea("Select the look of RapidMiner. We recommend the more comfortable 'modern' look for most users.", 2, 40);
            lookAndFeelText.setLineWrap(true);
            lookAndFeelText.setWrapStyleWord(true);
            lookAndFeelText.setEditable(false);
            lookAndFeelText.setBackground(lookAndFeelPanel.getBackground());
            plafC.weightx = 0.0;
            plafC.weighty = 0.0;
            plafC.gridwidth = 0;
            plafLayout.setConstraints(lookAndFeelText, plafC);
            lookAndFeelPanel.add(lookAndFeelText);
            JLabel lookAndFeelLabel = new JLabel("Preferred Look: ");
            plafC.gridwidth = -1;
            plafLayout.setConstraints(lookAndFeelLabel, plafC);
            lookAndFeelPanel.add(lookAndFeelLabel);
            plafC.weightx = 1.0;
            plafC.gridwidth = 0;
            plafLayout.setConstraints(this.lookAndFeelBox, plafC);
            lookAndFeelPanel.add(this.lookAndFeelBox);
            mainPanel.add(Box.createVerticalStrut(15));
            mainPanel.add(lookAndFeelPanel);
        }
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 7, 7));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = InitialSettingsDialog.this.workspaceField.getText();
                if (path != null && path.length() > 0) {
                    InitialSettingsDialog.this.ok();
                } else {
                    JOptionPane.showMessageDialog(null, "Please specify a valid workspace directory.", "Empty Workspace", 0);
                }
            }
        });
        okButton.setPreferredSize(new Dimension(60, (int)okButton.getPreferredSize().getHeight()));
        buttonPanel.add(okButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public String getWorkspacePath() {
        return this.workspaceField.getText();
    }

    public int getSelectedLookAndFeel() {
        return this.lookAndFeelBox.getSelectedIndex();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void ok() {
        boolean allFine = true;
        if (this.forbiddenDirectory != null) {
            String newPath = this.getWorkspacePath();
            for (File checkDir = new File(newPath); checkDir != null; checkDir = checkDir.getParentFile()) {
                if (!checkDir.equals(this.forbiddenDirectory)) continue;
                allFine = false;
                break;
            }
        }
        if (!allFine) {
            SwingTools.showVerySimpleErrorMessage("Cannot change workspace: location not possible.");
        } else {
            this.ok = true;
            this.dispose();
        }
    }
}

