/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.ExtendedVertexShapeTransformer;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.graphs.ShapeBasedTreeLayout;
import com.rapidminer.tools.LogService;
import edu.uci.ics.jung.algorithms.layout.BalloonLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSelection<V, E>
extends JComboBox {
    private static final long serialVersionUID = 8924517975475876102L;
    private GraphViewer<V, E> graphViewer;
    private transient Graph graph;
    private Map<String, Class> layoutMap = null;
    private boolean animate = true;
    private Layout<V, E> layout;

    public LayoutSelection(GraphViewer<V, E> graphViewer, Graph<V, E> graph) {
        this.graphViewer = graphViewer;
        this.graph = graph;
        this.layout = new ISOMLayout(graph);
        this.layoutMap = new LinkedHashMap<String, Class>();
        if (graph instanceof Forest) {
            this.layoutMap.put("Tree", ShapeBasedTreeLayout.class);
            this.layoutMap.put("Tree (Tight)", TreeLayout.class);
            this.layoutMap.put("Radial", RadialTreeLayout.class);
            this.layoutMap.put("Balloon", BalloonLayout.class);
        }
        this.layoutMap.put("ISOM", ISOMLayout.class);
        this.layoutMap.put("KKLayout", KKLayout.class);
        this.layoutMap.put("FRLayout", FRLayout2.class);
        this.layoutMap.put("Circle", CircleLayout.class);
        this.layoutMap.put("Spring", SpringLayout2.class);
        Iterator<String> it = this.layoutMap.keySet().iterator();
        while (it.hasNext()) {
            this.addItem(it.next());
        }
        this.addActionListener(this);
    }

    public Layout<V, E> getSelectedLayout() {
        return this.layout;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.setLayout();
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean getAnimate() {
        return this.animate;
    }

    public void setLayout() {
        String layoutName = (String)this.getSelectedItem();
        Class layoutClass = null;
        try {
            layoutClass = this.layoutMap.get(layoutName);
        }
        catch (Exception e) {
            LogService.getGlobal().logError("Layout could not be intialized: " + e.getMessage());
        }
        if (layoutClass != null) {
            try {
                Constructor constructor = null;
                Object o = null;
                if (layoutClass == ShapeBasedTreeLayout.class) {
                    constructor = layoutClass.getConstructor(Forest.class, Transformer.class);
                    o = constructor.newInstance(this.graph, new ExtendedVertexShapeTransformer<V>(this.graphViewer.getGraphCreator()));
                } else if (layoutClass == TreeLayout.class || layoutClass == BalloonLayout.class || layoutClass == RadialTreeLayout.class) {
                    constructor = layoutClass.getConstructor(Forest.class);
                    o = constructor.newInstance(this.graph);
                } else {
                    constructor = layoutClass.getConstructor(Graph.class);
                    o = constructor.newInstance(this.graph);
                }
                if (o != null) {
                    this.layout = o;
                    this.graphViewer.changeLayout(this.layout, this.animate, 0, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

