/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeBasedTreeLayout<V, E>
implements Layout<V, E> {
    private static final int DEFAULT_WIDTH = 70;
    private static final int DEFAULT_HEIGHT = 70;
    private static final int MARGIN = 5;
    private Dimension size = new Dimension(600, 600);
    private Forest<V, E> graph;
    protected Map<V, Point2D> locations = LazyMap.decorate(new HashMap(), (Transformer)new Transformer<V, Point2D>(){

        public Point2D transform(V arg0) {
            return new Point2D.Double();
        }
    });
    private Collection<V> roots;
    private Transformer<V, Shape> shapeTransformer;

    public List<V> getAtomics(V p) {
        ArrayList v = new ArrayList();
        this.getAtomics(p, v);
        return v;
    }

    private void getAtomics(V p, List<V> v) {
        for (Object c : this.graph.getSuccessors(p)) {
            if (this.graph.getSuccessors(c).size() == 0) {
                v.add(c);
                continue;
            }
            this.getAtomics(c, v);
        }
    }

    public ShapeBasedTreeLayout(Forest<V, E> g, Transformer<V, Shape> shapeTransformer) {
        this.graph = g;
        this.roots = this.getRoots(g);
        this.shapeTransformer = shapeTransformer;
        this.calculateLocations();
    }

    private Collection<V> getRoots(Forest<V, E> forest) {
        HashSet<Object> roots = new HashSet<Object>();
        for (Tree tree : forest.getTrees()) {
            roots.add(tree.getRoot());
        }
        return roots;
    }

    public Dimension getCurrentSize() {
        return this.size;
    }

    private void calculateLocations() {
        double xOffset = 100.0;
        double yOffset = 30.0;
        if (this.roots.size() > 0 && this.graph != null) {
            for (V v : this.roots) {
                this.calculateLocations(v, xOffset, yOffset);
                double currentWidth = this.calculateWidth(v);
                xOffset += currentWidth;
                xOffset += 5.0;
            }
        }
    }

    void calculateLocations(V v, double xOffset, double yOffset) {
        double currentWidth = this.calculateWidth(v);
        this.setPosition(v, xOffset + currentWidth / 2.0, yOffset);
        yOffset += 70.0;
        int childrenNum = this.graph.getSuccessors(v).size();
        if (childrenNum != 0) {
            boolean first = true;
            for (Object element : this.graph.getSuccessors(v)) {
                if (!first) {
                    xOffset += 5.0;
                }
                this.calculateLocations(element, xOffset, yOffset);
                double totalChildrenWidth = this.calculateWidth(element);
                xOffset += totalChildrenWidth;
                first = false;
            }
        }
    }

    private double calculateWidth(V v) {
        Shape shape;
        double childrenWidthSum = 0.0;
        int childrenNum = this.graph.getSuccessors(v).size();
        if (childrenNum != 0) {
            boolean first = true;
            for (Object element : this.graph.getSuccessors(v)) {
                if (!first) {
                    childrenWidthSum += 5.0;
                }
                childrenWidthSum += this.calculateWidth(element);
                first = false;
            }
        }
        double width = 70.0;
        if (this.shapeTransformer != null && (shape = (Shape)this.shapeTransformer.transform(v)) != null) {
            width = shape.getBounds().getWidth();
        }
        double size = Math.max(width, childrenWidthSum);
        size = Math.max(0.0, size);
        return size;
    }

    public void setSize(Dimension size) {
        this.size = size;
        this.calculateLocations();
    }

    private void setPosition(V vertex, double x, double y) {
        this.locations.get(vertex).setLocation(new Point2D.Double(x, y));
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void initialize() {
    }

    public boolean isLocked(V v) {
        return false;
    }

    public void lock(V v, boolean state) {
    }

    public void reset() {
    }

    public void setGraph(Graph<V, E> graph) {
        if (!(graph instanceof Forest)) {
            throw new IllegalArgumentException("graph must be a Forest");
        }
        this.graph = (Forest)graph;
        this.calculateLocations();
    }

    public void setInitializer(Transformer<V, Point2D> initializer) {
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.size.getWidth() / 2.0, this.size.getHeight() / 2.0);
    }

    public void setLocation(V v, Point2D location) {
        this.locations.get(v).setLocation(location);
    }

    public Point2D transform(V v) {
        return this.locations.get(v);
    }
}

