/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyValueCellEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class DefaultPropertyValueCellEditor
extends DefaultCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 3594466409311826645L;
    private boolean useEditorAsRenderer = false;

    public DefaultPropertyValueCellEditor(final ParameterTypeCategory type) {
        super(new JComboBox<String>(type.getValues()));
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -2104662561680969750L;

            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex(-1);
                } else {
                    try {
                        Integer index = Integer.valueOf(x.toString());
                        super.setValue(index);
                        ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex(index);
                    }
                    catch (NumberFormatException e) {
                        int index = type.getIndex(x.toString());
                        super.setValue(index);
                        ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex(index);
                    }
                }
            }

            public Object getCellEditorValue() {
                return Integer.valueOf(((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).getSelectedIndex()).toString();
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public DefaultPropertyValueCellEditor(ParameterTypeStringCategory type) {
        super(new JComboBox<String>(type.getValues()));
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        if (type.isEditable()) {
            ((JComboBox)this.editorComponent).setEditable(true);
        }
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -5592150438626222295L;

            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(x);
                    ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedItem(x);
                } else {
                    String value = x.toString();
                    super.setValue(value);
                    ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedItem(value);
                }
            }

            public Object getCellEditorValue() {
                String selected = (String)((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).getSelectedItem();
                if (selected != null && selected.trim().length() == 0) {
                    selected = null;
                }
                return selected;
            }
        };
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeBoolean type) {
        super(new JCheckBox());
        ((JCheckBox)this.editorComponent).setHorizontalAlignment(0);
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = 152467444047540403L;

            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JCheckBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelected((Boolean)type.getDefaultValue());
                } else {
                    Boolean value = Tools.booleanValue(x.toString(), (Boolean)type.getDefaultValue());
                    super.setValue(value);
                    ((JCheckBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelected(value);
                }
            }

            public Object getCellEditorValue() {
                return Boolean.valueOf(Tools.booleanValue(Boolean.valueOf(((JCheckBox)DefaultPropertyValueCellEditor.this.editorComponent).isSelected()).toString(), (Boolean)type.getDefaultValue())).toString();
            }
        };
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeInt type) {
        super(new JTextField());
        ((JTextField)this.editorComponent).setHorizontalAlignment(2);
        ((JTextField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = 152467444047540403L;

            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                } else {
                    super.setValue(x.toString());
                    try {
                        if (this.value != null) {
                            Integer value = Integer.valueOf(x.toString());
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(value.toString());
                        } else {
                            Integer defaultValue = (Integer)type.getDefaultValue();
                            if (defaultValue != null) {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                            } else {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        String text = x.toString();
                        if (text.startsWith("%{") && text.endsWith("}")) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(text);
                        }
                        Integer defaultValue = (Integer)type.getDefaultValue();
                        if (defaultValue != null) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                        }
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                    }
                }
            }

            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                try {
                    int i = Integer.parseInt(text);
                    if ((double)i < type.getMinValue()) {
                        i = (int)type.getMinValue();
                    }
                    if ((double)i > type.getMaxValue()) {
                        i = (int)type.getMaxValue();
                    }
                    return Integer.valueOf(i).toString();
                }
                catch (NumberFormatException e) {
                    if (text.startsWith("%{") && text.endsWith("}")) {
                        return text;
                    }
                    Integer defaultValue = (Integer)type.getDefaultValue();
                    if (defaultValue != null) {
                        return type.getDefaultValue().toString();
                    }
                    return null;
                }
            }
        };
        this.editorComponent.setToolTipText(String.valueOf(type.getDescription()) + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeDouble type) {
        super(new JTextField());
        ((JTextField)this.editorComponent).setHorizontalAlignment(2);
        ((JTextField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = 5764937097891322370L;

            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                } else {
                    super.setValue(x.toString());
                    try {
                        if (this.value != null) {
                            Double value = Double.valueOf(x.toString());
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(value.toString());
                        } else {
                            Integer defaultValue = (Integer)type.getDefaultValue();
                            if (defaultValue != null) {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                            } else {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        String text = x.toString();
                        if (text.startsWith("%{") && text.endsWith("}")) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(text);
                        }
                        Integer defaultValue = (Integer)type.getDefaultValue();
                        if (defaultValue != null) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                        }
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                    }
                }
            }

            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                try {
                    double d = Double.parseDouble(text);
                    if (d < type.getMinValue()) {
                        d = type.getMinValue();
                    }
                    if (d > type.getMaxValue()) {
                        d = type.getMaxValue();
                    }
                    return Double.valueOf(d).toString();
                }
                catch (NumberFormatException e) {
                    if (text.startsWith("%{") && text.endsWith("}")) {
                        return text;
                    }
                    Double defaultValue = (Double)type.getDefaultValue();
                    if (defaultValue != null) {
                        return type.getDefaultValue().toString();
                    }
                    return null;
                }
            }
        };
        this.editorComponent.setToolTipText(String.valueOf(type.getDescription()) + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypePassword type) {
        super(new JPasswordField());
        ((JPasswordField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -2736861014783898296L;

            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                } else {
                    String value = x.toString();
                    super.setValue(value);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(value.toString());
                }
            }

            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                if (text == null || text.length() == 0) {
                    if (type.getDefaultValue() != null) {
                        return type.getDefaultValue().toString();
                    }
                    return null;
                }
                return text.toString();
            }
        };
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterType type) {
        super(new JTextField());
        ((JTextField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -2868203350553070093L;

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(x.toString());
                }
            }

            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                if (text == null || text.length() == 0) {
                    if (type.getDefaultValue() == null) {
                        return null;
                    }
                    return type.getDefaultValue().toString();
                }
                return text.toString();
            }
        };
        this.useEditorAsRenderer = true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (isSelected) {
            c.setBackground(SwingTools.LIGHTEST_BLUE);
        } else {
            c.setBackground(Color.WHITE);
        }
        return c;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.delegate.setValue(value);
        if (isSelected) {
            this.editorComponent.setBackground(SwingTools.LIGHTEST_BLUE);
        } else {
            this.editorComponent.setBackground(Color.WHITE);
        }
        return this.editorComponent;
    }

    public boolean useEditorAsRenderer() {
        return this.useEditorAsRenderer;
    }

    public void setOperator(Operator operator) {
    }
}

