/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.properties.DefaultPropertyTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class OperatorPropertyTable
extends DefaultPropertyTable {
    private static final long serialVersionUID = -4129852766426437419L;
    private static final Font MESSAGE_FONT = new Font("SansSerif", 0, 11);
    private static final Icon WARNING_ICON = SwingTools.createIcon("16/warning.png");
    private MainFrame mainFrame;
    private transient Operator operator;
    private transient ParameterType[] parameterTypes;
    private boolean expertMode = false;
    private JLabel propertyMessageLabel;

    public OperatorPropertyTable(MainFrame mainFrame, JLabel propertyMessageLabel) {
        this.mainFrame = mainFrame;
        this.propertyMessageLabel = propertyMessageLabel;
        this.propertyMessageLabel.setMinimumSize(new Dimension(0, 0));
        this.propertyMessageLabel.setFont(MESSAGE_FONT);
        this.propertyMessageLabel.setForeground(new Color(150, 150, 150));
        this.propertyMessageLabel.setOpaque(false);
        this.propertyMessageLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.propertyMessageLabel.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
                OperatorPropertyTable.this.mainFrame.toggleExpertMode();
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
        this.setOperator(null);
    }

    public void toggleExpertMode() {
        this.expertMode = !this.expertMode;
        this.setOperator(this.operator);
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void refresh() {
        this.setOperator(this.operator);
    }

    public void stopCurrentEditing() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
    }

    public void setOperator(Operator operator) {
        this.stopCurrentEditing();
        int hidden = 0;
        this.operator = operator;
        if (operator != null) {
            List<ParameterType> parameters = operator.getParameterTypes();
            LinkedList<ParameterType> viewableParameters = new LinkedList<ParameterType>();
            for (ParameterType type : parameters) {
                if (type.isHidden()) continue;
                if (this.expertMode || !type.isExpert()) {
                    viewableParameters.add(type);
                    continue;
                }
                ++hidden;
            }
            this.parameterTypes = new ParameterType[viewableParameters.size()];
            viewableParameters.toArray(this.parameterTypes);
        } else {
            this.parameterTypes = new ParameterType[0];
        }
        this.updateTableData(this.parameterTypes.length);
        int i = 0;
        while (i < this.parameterTypes.length) {
            this.getModel().setValueAt(this.parameterTypes[i].getKey(), i, 0);
            Object value = this.parameterTypes[i].getDefaultValue();
            try {
                value = operator.getParameters().getParameter(this.parameterTypes[i].getKey());
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            this.getModel().setValueAt(value, i, 1);
            ++i;
        }
        OperatorPropertyTable.updateEditorsAndRenderers(this);
        this.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                OperatorPropertyTable.this.setValue(e.getFirstRow(), OperatorPropertyTable.this.getModel().getValueAt(e.getFirstRow(), 1));
                OperatorPropertyTable.this.mainFrame.processChanged();
                OperatorPropertyTable.this.getModel().removeTableModelListener(this);
                OperatorPropertyTable.this.refresh();
            }
        });
        if (hidden == 1) {
            this.propertyMessageLabel.setText("There is 1 hidden parameter shown in expert mode only.");
            if (WARNING_ICON != null) {
                this.propertyMessageLabel.setIcon(WARNING_ICON);
            }
            this.propertyMessageLabel.setCursor(new Cursor(12));
        } else if (hidden > 1) {
            this.propertyMessageLabel.setText("There are " + hidden + " hidden parameters shown in expert mode only.");
            if (WARNING_ICON != null) {
                this.propertyMessageLabel.setIcon(WARNING_ICON);
            }
            this.propertyMessageLabel.setCursor(new Cursor(12));
        } else {
            this.propertyMessageLabel.setText(null);
            this.propertyMessageLabel.setIcon(null);
            this.propertyMessageLabel.setCursor(Cursor.getDefaultCursor());
        }
    }

    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    public Operator getOperator(int row) {
        return this.operator;
    }
}

