/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererService {
    private static Set<String> objectNames = new TreeSet<String>();
    private static Map<String, List<Renderer>> objectRenderers = new HashMap<String, List<Renderer>>();
    private static Map<String, Class<?>> objectClasses = new HashMap();
    private static Map<String, Class<IOObject>> objectSuperTypes = new HashMap<String, Class<IOObject>>();
    private static Map<String, Boolean> reportableMap = new HashMap<String, Boolean>();
    private static Map<Class<?>, String> class2NameMap = new HashMap();

    public static void init() {
        URL url = Tools.getResource("ioobjects.xml");
        RendererService.init("ioobjects.xml", url, RendererService.class.getClassLoader());
    }

    public static void init(URL ioObjectsURL) {
        RendererService.init(ioObjectsURL.getFile(), ioObjectsURL, RendererService.class.getClassLoader());
    }

    public static void init(String name, InputStream in) {
        RendererService.init(name, in, RendererService.class.getClassLoader());
    }

    public static void init(String name, URL ioObjectsURL, ClassLoader classLoader) {
        block13: {
            InputStream in = null;
            try {
                try {
                    if (ioObjectsURL != null) {
                        in = ioObjectsURL.openStream();
                        RendererService.init(name, in, classLoader);
                    }
                }
                catch (IOException e) {
                    LogService.getGlobal().logError("Cannot initialize io object description: Cannot parse document: " + e);
                    if (in == null) break block13;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void init(String rendererFileName, InputStream in, ClassLoader classLoader) {
        LogService.getGlobal().log("Loading renderers from '" + rendererFileName + "'.", 3);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            Element ioObjectsElement = document.getDocumentElement();
            if (ioObjectsElement.getTagName().equals("ioobjects")) {
                NodeList ioObjectNodes = ioObjectsElement.getElementsByTagName("ioobject");
                int i = 0;
                while (i < ioObjectNodes.getLength()) {
                    Node ioObjectNode = ioObjectNodes.item(i);
                    if (ioObjectNode instanceof Element) {
                        Element ioObjectElement = (Element)ioObjectNode;
                        String name = ioObjectElement.getAttribute("name");
                        String className = ioObjectElement.getAttribute("class");
                        String superTypeName = ioObjectElement.getAttribute("supertype");
                        String reportableString = "true";
                        if (ioObjectElement.hasAttribute("reportable")) {
                            reportableString = ioObjectElement.getAttribute("reportable");
                        }
                        boolean reportable = Tools.booleanValue(reportableString, true);
                        NodeList rendererNodes = ioObjectElement.getElementsByTagName("renderer");
                        LinkedList<String> renderers = new LinkedList<String>();
                        int k = 0;
                        while (k < rendererNodes.getLength()) {
                            Node rendererNode = rendererNodes.item(k);
                            if (rendererNode instanceof Element) {
                                Element rendererElement = (Element)rendererNode;
                                String rendererName = rendererElement.getTextContent();
                                renderers.add(rendererName);
                            }
                            ++k;
                        }
                        RendererService.registerRenderers(name, className, superTypeName, reportable, renderers, classLoader);
                    }
                    ++i;
                }
            } else {
                LogService.getGlobal().logError("Cannot initialize io object description: Outermost tag of a ioobjects.xml definition must be <ioobjects>!");
            }
        }
        catch (IOException e) {
            LogService.getGlobal().logError("Cannot initialize io object description: Cannot parse document: " + e);
        }
        catch (ParserConfigurationException e) {
            LogService.getGlobal().logError("Cannot initialize io object description: " + e);
        }
        catch (SAXException e) {
            LogService.getGlobal().logError("Cannot initialize io object description: Cannot parse document: " + e);
        }
    }

    public static void registerRenderers(String name, String className, String superTypeName, boolean reportable, List<String> rendererNames, ClassLoader classLoader) {
        objectNames.add(name);
        try {
            Class<?> clazz = Class.forName(className, true, classLoader);
            Class<?> superType = Class.forName(superTypeName, true, classLoader);
            LinkedList<Renderer> renderers = new LinkedList<Renderer>();
            for (String rendererName : rendererNames) {
                Class<?> rendererClass;
                try {
                    rendererClass = Class.forName(rendererName, true, classLoader);
                }
                catch (Exception e) {
                    rendererClass = Class.forName(rendererName);
                }
                Renderer renderer = (Renderer)rendererClass.newInstance();
                renderers.add(renderer);
            }
            objectRenderers.put(name, renderers);
            objectClasses.put(name, clazz);
            objectSuperTypes.put(name, superType);
            class2NameMap.put(clazz, name);
            reportableMap.put(name, reportable);
        }
        catch (Throwable e) {
            LogService.getGlobal().logWarning("Cannot register renderer: " + e);
        }
    }

    public static Set<String> getAllRenderableObjectNames() {
        return objectNames;
    }

    public static Set<String> getAllReportableObjectNames() {
        TreeSet<String> result = new TreeSet<String>();
        for (String name : objectNames) {
            Boolean reportable = reportableMap.get(name);
            if (reportable == null || !reportable.booleanValue()) continue;
            result.add(name);
        }
        return result;
    }

    public static String getName(Class<?> clazz) {
        String result = class2NameMap.get(clazz);
        if (result == null) {
            result = RendererService.getNameForSuperClass(clazz);
        }
        return result;
    }

    private static String getNameForSuperClass(Class<?> clazz) {
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return null;
        }
        String result = class2NameMap.get(superClazz);
        if (result == null) {
            return RendererService.getNameForSuperClass(superClazz);
        }
        return result;
    }

    public static Class<?> getClass(String name) {
        return objectClasses.get(name);
    }

    public static Class<IOObject> getSuperType(String name) {
        return objectSuperTypes.get(name);
    }

    public static List<Renderer> getRenderers(String name) {
        return objectRenderers.get(name);
    }

    public static Renderer getRenderer(String reportableName, String rendererName) {
        List<Renderer> renderers = RendererService.getRenderers(reportableName);
        for (Renderer renderer : renderers) {
            if (!renderer.getName().equals(rendererName)) continue;
            return renderer;
        }
        return null;
    }
}

