/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.performance;

import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.viewer.PerformanceVectorViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceVectorRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "Table / Plot View";
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        PerformanceVector performanceVector = (PerformanceVector)renderable;
        String criterionName = null;
        try {
            criterionName = this.getParameterAsString("criterion");
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        PerformanceCriterion criterion = null;
        if (criterionName != null) {
            criterion = performanceVector.getCriterion(criterionName);
        }
        if (criterion == null) {
            criterion = performanceVector.getMainCriterion();
        }
        return criterion;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        PerformanceVector performanceVector = (PerformanceVector)renderable;
        return new PerformanceVectorViewer(performanceVector, ioContainer);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("criterion", "Indicates which criterion should be reported (empty: use main criterion).", true));
        return types;
    }
}

