/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.templates.NewBuildingBlockMenu;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.BuildingBlockService;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;

public class NewBuildingBlockDialog
extends JDialog {
    private static final long serialVersionUID = 4234757981716378086L;
    private boolean ok = false;
    private JList buildingBlockList = new JList();

    public NewBuildingBlockDialog(MainFrame mainFrame) {
        super(mainFrame, "Insert Building Block", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel textPanel = SwingTools.createTextPanel("Add Building Block...", "Please select the building block which should be added.");
        c.gridwidth = 0;
        layout.setConstraints(textPanel, c);
        mainPanel.add(textPanel);
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        List<BuildingBlock> buildingBlocks = BuildingBlockService.getBuildingBlocks();
        Iterator<BuildingBlock> i = buildingBlocks.iterator();
        while (i.hasNext()) {
            BuildingBlock currentBB = i.next();
            if (NewBuildingBlockMenu.checkBuildingBlock(currentBB)) continue;
            i.remove();
            LogService.getGlobal().log("Cannot initialize building block '" + currentBB.getName(), 5);
        }
        BuildingBlock[] buildingBlockArray = new BuildingBlock[buildingBlocks.size()];
        buildingBlocks.toArray(buildingBlockArray);
        this.buildingBlockList.setSelectionMode(0);
        this.buildingBlockList.setListData(buildingBlockArray);
        ExtendedJScrollPane listPane = new ExtendedJScrollPane(this.buildingBlockList);
        c.gridwidth = 0;
        c.weighty = 1.0;
        layout.setConstraints(listPane, c);
        mainPanel.add(listPane);
        c.weighty = 0.0;
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewBuildingBlockDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewBuildingBlockDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        rootPanel.add((Component)mainPanel, "Center");
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setSize(250, 400);
        this.setLocationRelativeTo(mainFrame);
    }

    private void ok() {
        this.ok = true;
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public BuildingBlock getSelectedBuildingBlock() {
        return (BuildingBlock)this.buildingBlockList.getSelectedValue();
    }
}

