/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private String name = "unnamed";
    private String description = "none";
    private String configFile;
    private List<String[]> parameters = new LinkedList<String[]>();
    private File templateFile = null;

    public Template() {
    }

    public Template(File file) throws InstantiationException {
        this.templateFile = file;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new FileReader(this.templateFile));
                this.name = in.readLine();
                this.description = in.readLine();
                this.configFile = in.readLine();
                String line = null;
                while ((line = in.readLine()) != null) {
                    this.parameters.add(line.split("\\."));
                }
            }
            catch (IOException e) {
                LogService.getGlobal().logError("Cannot read template file: " + file);
                throw new InstantiationException("Cannot read template file: " + file);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogService.getGlobal().logError("Cannot close stream to template file: " + e.getMessage());
                }
            }
        }
    }

    public Template(String name, String description, String configFile, List<String[]> parameters) {
        this.name = name;
        this.description = description;
        this.configFile = configFile;
        this.parameters = parameters;
    }

    public File getFile() {
        return this.templateFile;
    }

    public String getFilename() {
        return this.configFile;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String[]> getParameters() {
        return this.parameters;
    }

    public String toHTML() {
        return "<b>" + this.name + "</b><br />" + this.description;
    }

    public void save(File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            out.println(this.name);
            out.println(this.description);
            out.println(this.configFile);
            for (String[] pair : this.parameters) {
                out.println(String.valueOf(pair[0]) + "." + pair[1]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

