/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExtendedJSliderToolTips {
    public static void enableSliderToolTips(final JSlider slider) {
        slider.addChangeListener(new ChangeListener(){
            private boolean adjusting = false;
            private String oldTooltip;

            public void stateChanged(ChangeEvent e) {
                if (slider.getModel().getValueIsAdjusting()) {
                    if (!this.adjusting) {
                        this.oldTooltip = slider.getToolTipText();
                        this.adjusting = true;
                    }
                    slider.setToolTipText(String.valueOf(slider.getValue()));
                    ExtendedJSliderToolTips.hideToolTip(slider);
                    ExtendedJSliderToolTips.postToolTip(slider);
                } else {
                    ExtendedJSliderToolTips.hideToolTip(slider);
                    slider.setToolTipText(this.oldTooltip);
                    this.adjusting = false;
                    this.oldTooltip = null;
                }
            }
        });
    }

    public static void postToolTip(JComponent comp) {
        Action action = comp.getActionMap().get("postTip");
        if (action == null) {
            return;
        }
        ActionEvent ae = new ActionEvent(comp, 1001, "postTip", EventQueue.getMostRecentEventTime(), 0);
        action.actionPerformed(ae);
    }

    public static void hideToolTip(JComponent comp) {
        Action action = comp.getActionMap().get("hideTip");
        if (action == null) {
            return;
        }
        ActionEvent ae = new ActionEvent(comp, 1001, "hideTip", EventQueue.getMostRecentEventTime(), 0);
        action.actionPerformed(ae);
    }
}

