/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.OperatorInfoScreen;
import com.rapidminer.gui.operatortree.TransferableOperator;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.OperatorListCellRenderer;
import com.rapidminer.gui.tools.OperatorListInfoOperatorAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import java.awt.Frame;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorList
extends JList
implements DragSourceListener,
DragGestureListener,
MouseListener {
    private static final long serialVersionUID = -2719941529572427942L;
    public final transient Action INFO_OPERATOR_ACTION_24 = new OperatorListInfoOperatorAction(this, IconSize.SMALL);
    public final transient Action INFO_OPERATOR_ACTION_32 = new OperatorListInfoOperatorAction(this, IconSize.MIDDLE);
    private MainFrame mainFrame;
    private OperatorListCellRenderer operatorDialogCellRenderer;
    private DragSource dragSource;
    private transient Operator selectedOperator;

    public OperatorList() {
        this(false, true);
    }

    public OperatorList(boolean horizontalWrap, boolean coloredCellBackgrounds) {
        this.operatorDialogCellRenderer = new OperatorListCellRenderer(coloredCellBackgrounds);
        if (horizontalWrap) {
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(-1);
        }
        this.setCellRenderer(this.operatorDialogCellRenderer);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.setSelectionMode(0);
        this.addMouseListener(this);
        this.mainFrame = RapidMinerGUI.getMainFrame();
    }

    public void setOperatorDescriptions(Vector<OperatorDescription> descriptions) {
        this.setListData(descriptions);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (Integer.valueOf(e.getDragAction()) != 1) {
            return;
        }
        Point dragOrigin = e.getDragOrigin();
        int selectedIndex = this.locationToIndex(dragOrigin);
        if (selectedIndex != -1) {
            this.setSelectedIndex(selectedIndex);
        }
        OperatorDescription selectedListElement = (OperatorDescription)this.getSelectedValue();
        Operator selectedOperator = null;
        if (selectedListElement != null) {
            try {
                selectedOperator = selectedListElement.createOperatorInstance();
            }
            catch (OperatorCreationException ocE) {
                ocE.printStackTrace();
            }
            if (selectedOperator != null) {
                TransferableOperator selectedTransferableOperator = new TransferableOperator(selectedOperator);
                try {
                    e.startDrag(null, null, new Point(0, 0), selectedTransferableOperator, this);
                }
                catch (InvalidDnDOperationException dndE) {
                    dndE.printStackTrace();
                }
            }
        }
    }

    private Operator getSelectedOperator() {
        Point clickOrigin = this.getMousePosition();
        if (clickOrigin == null) {
            return null;
        }
        int selectedIndex = this.locationToIndex(clickOrigin);
        if (selectedIndex != -1) {
            this.setSelectedIndex(selectedIndex);
        }
        OperatorDescription selectedListElement = (OperatorDescription)this.getSelectedValue();
        Operator selectedOperator = null;
        if (selectedListElement != null) {
            try {
                selectedOperator = selectedListElement.createOperatorInstance();
            }
            catch (OperatorCreationException ocE) {
                ocE.printStackTrace();
            }
        }
        return selectedOperator;
    }

    public void showOperatorInfo() {
        if (this.selectedOperator != null) {
            OperatorInfoScreen infoScreen = new OperatorInfoScreen((Frame)this.mainFrame, this.selectedOperator);
            infoScreen.setVisible(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selectedOperator = this.getSelectedOperator();
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createOperatorPopupMenu().show(this, e.getX(), e.getY());
        }
    }

    private JPopupMenu createOperatorPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.INFO_OPERATOR_ACTION_24);
        return menu;
    }
}

