/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.gui.viewer.AssociationRuleFilterListener;
import com.rapidminer.operator.learner.associations.AssociationRule;
import com.rapidminer.operator.learner.associations.AssociationRuleGenerator;
import com.rapidminer.operator.learner.associations.AssociationRules;
import com.rapidminer.operator.learner.associations.Item;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssociationRuleFilter
extends JPanel {
    private static final long serialVersionUID = 5619543957729778883L;
    private static final int MAX_VALUE = 10000;
    private JComboBox criterionSelectorBox = new JComboBox<String>(AssociationRuleGenerator.CRITERIA);
    private JSlider criterionMinSlider = new JSlider(0, 0, 10000, 1000);
    private double[] minValues;
    private double[] maxValues;
    private JList conclusionList = null;
    private JComboBox conjunctionBox = new JComboBox<String>(AssociationRuleFilterListener.CONJUNCTION_NAMES);
    private Item[] itemArray;
    private List<AssociationRuleFilterListener> listeners = new LinkedList<AssociationRuleFilterListener>();
    private AssociationRules rules;

    public AssociationRuleFilter(AssociationRules rules) {
        this.rules = rules;
        this.itemArray = rules.getAllConclusionItems();
        this.minValues = new double[AssociationRuleGenerator.CRITERIA.length];
        this.maxValues = new double[AssociationRuleGenerator.CRITERIA.length];
        int i = 0;
        while (i < this.minValues.length) {
            this.minValues[i] = Double.POSITIVE_INFINITY;
            this.maxValues[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        for (AssociationRule rule : rules) {
            if (!Double.isInfinite(rule.getConfidence())) {
                this.minValues[0] = Math.min(this.minValues[0], rule.getConfidence());
                this.maxValues[0] = Math.max(this.maxValues[0], rule.getConfidence());
            }
            if (!Double.isInfinite(rule.getConviction())) {
                this.minValues[2] = Math.min(this.minValues[2], rule.getConviction());
                this.maxValues[2] = Math.max(this.maxValues[2], rule.getConviction());
            }
            if (!Double.isInfinite(rule.getGain())) {
                this.minValues[4] = Math.min(this.minValues[4], rule.getGain());
                this.maxValues[4] = Math.max(this.maxValues[4], rule.getGain());
            }
            if (!Double.isInfinite(rule.getLaplace())) {
                this.minValues[5] = Math.min(this.minValues[5], rule.getLaplace());
                this.maxValues[5] = Math.max(this.maxValues[5], rule.getLaplace());
            }
            if (!Double.isInfinite(rule.getLift())) {
                this.minValues[1] = Math.min(this.minValues[1], rule.getLift());
                this.maxValues[1] = Math.max(this.maxValues[1], rule.getLift());
            }
            if (Double.isInfinite(rule.getPs())) continue;
            this.minValues[3] = Math.min(this.minValues[3], rule.getPs());
            this.maxValues[3] = Math.max(this.maxValues[3], rule.getPs());
        }
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(4, 4, 4, 4);
        this.conjunctionBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AssociationRuleFilter.this.adjustFilter();
            }
        });
        JLabel label = new JLabel("Conjunction Type:");
        layout.setConstraints(label, c);
        this.add(label);
        layout.setConstraints(this.conjunctionBox, c);
        this.add(this.conjunctionBox);
        ExtendedListModel model = new ExtendedListModel();
        Item[] itemArray = this.itemArray;
        int n = this.itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            model.addElement(item, "The item '" + item.toString() + "'.");
            ++n2;
        }
        this.conclusionList = new ExtendedJList(model, 200);
        this.conclusionList.setSelectionMode(2);
        this.conclusionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AssociationRuleFilter.this.adjustFilter();
                }
            }
        });
        label = new JLabel("Conclusions:");
        layout.setConstraints(label, c);
        this.add(label);
        ExtendedJScrollPane listPane = new ExtendedJScrollPane(this.conclusionList);
        listPane.setHorizontalScrollBarPolicy(30);
        c.weighty = 1.0;
        c.weightx = 0.0;
        layout.setConstraints(listPane, c);
        this.add(listPane);
        c.weighty = 0.0;
        c.weightx = 1.0;
        label = new JLabel("Min. Criterion:");
        layout.setConstraints(label, c);
        this.add(label);
        this.criterionSelectorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AssociationRuleFilter.this.adjustFilter();
            }
        });
        layout.setConstraints(this.criterionSelectorBox, c);
        this.add(this.criterionSelectorBox);
        label = new JLabel("Min. Criterion Value:");
        layout.setConstraints(label, c);
        this.add(label);
        this.criterionMinSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!AssociationRuleFilter.this.criterionMinSlider.getValueIsAdjusting()) {
                    AssociationRuleFilter.this.adjustFilter();
                }
            }
        });
        layout.setConstraints(this.criterionMinSlider, c);
        this.add(this.criterionMinSlider);
    }

    private void adjustFilter() {
        int conjunctionMode = this.conjunctionBox.getSelectedIndex();
        Item[] searchFilter = null;
        int[] selectedIndices = this.conclusionList.getSelectedIndices();
        if (selectedIndices.length > 0 && selectedIndices.length <= this.itemArray.length) {
            searchFilter = new Item[selectedIndices.length];
            int counter = 0;
            int[] nArray = selectedIndices;
            int n = selectedIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                searchFilter[counter++] = this.itemArray[s];
                ++n2;
            }
        }
        double minRatio = (double)this.criterionMinSlider.getValue() / 10000.0;
        this.fireFilteringEvent(searchFilter, conjunctionMode, minRatio);
    }

    public void addAssociationRuleFilterListener(AssociationRuleFilterListener listener) {
        this.listeners.add(listener);
    }

    public void removeAssociationRuleFilterListener(AssociationRuleFilterListener listener) {
        this.listeners.remove(listener);
    }

    private void fireFilteringEvent(Item[] searchFilter, int conjunctionMode, double minRatio) {
        boolean[] filter = this.getFilter(this.rules, searchFilter, conjunctionMode, minRatio);
        for (AssociationRuleFilterListener listener : this.listeners) {
            listener.setFilter(filter);
        }
    }

    private boolean[] getFilter(AssociationRules rules, Item[] filter, int conjunctionMode, double minRatio) {
        boolean[] mapping = new boolean[rules.getNumberOfRules()];
        int counter = 0;
        for (AssociationRule rule : rules) {
            mapping[counter] = this.getCriterionValue(rule) >= this.getCriterionMinValue(minRatio) ? this.checkForItem(filter, rule, conjunctionMode) : false;
            ++counter;
        }
        return mapping;
    }

    private double getCriterionMinValue(double minRatio) {
        int criterionSelection = this.criterionSelectorBox.getSelectedIndex();
        return this.minValues[criterionSelection] + (this.maxValues[criterionSelection] - this.minValues[criterionSelection]) * minRatio;
    }

    private double getCriterionValue(AssociationRule rule) {
        int criterionSelection = this.criterionSelectorBox.getSelectedIndex();
        switch (criterionSelection) {
            case 1: {
                return rule.getLift();
            }
            case 2: {
                return rule.getConviction();
            }
            case 3: {
                return rule.getPs();
            }
            case 4: {
                return rule.getGain();
            }
            case 5: {
                return rule.getLaplace();
            }
        }
        return rule.getConfidence();
    }

    private boolean checkForItem(Item[] filter, AssociationRule rule, int conjunctionMode) {
        if (filter == null) {
            return true;
        }
        if (conjunctionMode == 1) {
            boolean found = false;
            Item[] itemArray = filter;
            int n = filter.length;
            int n2 = 0;
            while (n2 < n) {
                Item filterItem = itemArray[n2];
                Iterator<Item> c = rule.getConclusionItems();
                while (c.hasNext()) {
                    Item conclusionItem = c.next();
                    if (!filterItem.equals(conclusionItem)) continue;
                    found = true;
                    break;
                }
                if (found) break;
                ++n2;
            }
            return found;
        }
        boolean found = true;
        Item[] itemArray = filter;
        int n = filter.length;
        int n3 = 0;
        while (n3 < n) {
            Item filterItem = itemArray[n3];
            Iterator<Item> c = rule.getConclusionItems();
            while (c.hasNext()) {
                Item conclusionItem = c.next();
                if (filterItem.equals(conclusionItem)) continue;
                found = false;
                break;
            }
            if (!found) break;
            ++n3;
        }
        return found;
    }
}

