/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.IOContainer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ContainerModelViewer
extends JPanel {
    private static final long serialVersionUID = -322963469866592863L;
    private Component current = null;

    public ContainerModelViewer(final GroupedModel model, final IOContainer container) {
        final GridBagLayout gridBag = new GridBagLayout();
        final GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridBag);
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        LinkedList<String> modelNameList = new LinkedList<String>();
        int i = 0;
        while (i < model.getNumberOfModels()) {
            modelNameList.add(model.getModel(i).getName());
            ++i;
        }
        String[] modelNames = new String[modelNameList.size()];
        modelNameList.toArray(modelNames);
        final JList<String> modelList = new JList<String>(modelNames);
        modelList.setBorder(BorderFactory.createTitledBorder("Model Selector"));
        modelList.setSelectionMode(0);
        modelList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ContainerModelViewer.this.current != null) {
                    ContainerModelViewer.this.remove(ContainerModelViewer.this.current);
                }
                ContainerModelViewer.this.current = model.getModel(modelList.getSelectedIndex()).getVisualizationComponent(container);
                c.gridwidth = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                gridBag.setConstraints(ContainerModelViewer.this.current, c);
                ContainerModelViewer.this.add(ContainerModelViewer.this.current);
            }
        });
        if (model.getNumberOfModels() > 1) {
            ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(modelList);
            c.gridwidth = -1;
            c.weightx = 0.1;
            c.weighty = 0.0;
            gridBag.setConstraints(listScrollPane, c);
            this.add(listScrollPane);
            modelList.setSelectedIndices(new int[1]);
        } else if (model.getNumberOfModels() > 0) {
            this.current = model.getModel(modelList.getSelectedIndex()).getVisualizationComponent(container);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gridBag.setConstraints(this.current, c);
            this.add(this.current);
        } else {
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JLabel label = new JLabel("Grouped model is empty.");
            gridBag.setConstraints(label, c);
            this.add(label);
        }
    }
}

