/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8116530590493627673L;
    private transient DataTable dataTable;

    public DataTableViewerTableModel(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<Object> type = super.getColumnClass(column);
        type = this.dataTable.isDate(column) || this.dataTable.isTime(column) || this.dataTable.isDateTime(column) ? Date.class : (this.dataTable.isNumerical(column) ? Double.class : String.class);
        return type;
    }

    @Override
    public int getRowCount() {
        return this.dataTable.getNumberOfRows();
    }

    @Override
    public int getColumnCount() {
        return this.dataTable.getNumberOfColumns();
    }

    @Override
    public Object getValueAt(int row, int col) {
        DataTableRow tableRow = this.dataTable.getRow(row);
        if (this.dataTable.isDate(col) || this.dataTable.isTime(col) || this.dataTable.isDateTime(col)) {
            double value = tableRow.getValue(col);
            long milliseconds = (long)value;
            return new Date(milliseconds);
        }
        if (this.dataTable.isNominal(col)) {
            return this.dataTable.getValueAsString(tableRow, col);
        }
        return tableRow.getValue(col);
    }

    @Override
    public String getColumnName(int col) {
        return this.dataTable.getColumnName(col);
    }
}

